% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dream_Dataset.R
\docType{data}
\name{StackData}
\alias{StackData}
\title{Sample Stack Data}
\format{A list of 3 variables containing Gene Expression (GE), Reverse Phase Protein Array (RPPA) and drug sensitivity measure (AUC):
\describe{
  \item{GE}{Gene Expression (GE) data corresponding to cell lines tested by the drug 17-AAG taken from the Cancer Cell Line Encyclopedia. Relieff has been run to select the top 150 genes. }
  \item{RPPA}{Reverse Phase Protein Array (RPPA) data corresponding to cell lines tested by the drug 17-AAG taken from the MD Anderson Cell Lines Project. Relieff has been run to select the top 150 proteins.}
  \item{AUC}{Area under the Dose-Responce Curve (AUC) corresponding to the drug 17-AAG applied to each cell line. Taken from the Cancer Cell Line Encyclopedia. }
}}
\source{
\url{http://bioinformatics.mdanderson.org/main/MCLP:Overview}
\url{https://portals.broadinstitute.org/ccle}
}
\usage{
StackData
}
\description{
A demo dataset containing Gene Expression (GE), Reverse Phase Protein Array (RPPA) and drug sensitivity measure (AUC) for cancer cell lines that have been tested for the drug 17-AAG. Used to demonstrate the benefits of stacking by building an integrated model that will more effectively predict the AUC values given both GE and RPPA data.
}
\references{
	Barretina,J. and et al. (2012) The Cancer Cell Line Encyclopedia enables
predictive modelling of anticancer drug sensitivity. Nature, 483 (7391),
603–607.
	Li, J. and et al. (2016) Characterization of Human Cancer Cell Lines by Reverse-Phase Protein Arrays.
Cancer Cell (In Press).
}
\keyword{datasets}

