% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupICA.R
\name{group_sparseICA}
\alias{group_sparseICA}
\title{Perform Group Sparse Independent Component Analysis (Sparse ICA)}
\usage{
group_sparseICA(
  bids_path,
  subj_list = NULL,
  nu = "BIC",
  n.comp = 30,
  method = "C",
  ncore = 1,
  npc = 85,
  iter_std = 5,
  brainstructures = c("left", "right"),
  restarts = 40,
  positive_skewness = TRUE,
  use_irlba = TRUE,
  eps = 1e-06,
  maxit = 500,
  BIC_plot = TRUE,
  nu_list = seq(0.1, 4, 0.05),
  verbose = TRUE,
  BIC_verbose = FALSE,
  converge_plot = FALSE
)
}
\arguments{
\item{bids_path}{A character string specifying the root directory of the BIDS-formatted dataset.}

\item{subj_list}{A named list where each element corresponds to a subject and contains vectors of fMRI file names. If \code{NULL}, the subject list is generated automatically using \code{\link{create_group_list}}. Default is \code{NULL}.}

\item{nu}{A numeric value for the tuning parameter, or \code{"BIC"} to select \code{nu} using a BIC-like criterion. Default is \code{"BIC"}.}

\item{n.comp}{An integer specifying the number of components to estimate. Default is 30.}

\item{method}{A character string specifying the computation method for Sparse ICA. Options are \code{"C"} (default) for C-based computation or \code{"R"} for R-based computation.}

\item{ncore}{An integer specifying the number of cores to use for parallel processing. Default is 1.}

\item{npc}{An integer specifying the number of components to retain during subject-level PCA. Default is 85.}

\item{iter_std}{An integer specifying the number of iterative standardization steps to apply to fMRI data. Default is 5.}

\item{brainstructures}{A character vector specifying the brain structures to include in the analysis. Options are \code{"left"} (left cortex), \code{"right"} (right cortex), and/or \code{"subcortical"} (subcortex and cerebellum). Can also be \code{"all"} (obtain all three brain structures). Default is \code{c("left", "right")}.}

\item{restarts}{An integer specifying the number of random initializations for Sparse ICA. Default is 40.}

\item{positive_skewness}{A logical value indicating whether to enforce positive skewness on the estimated components. Default is \code{TRUE}.}

\item{use_irlba}{A logical value indicating whether to use the \code{irlba} method for fast truncated Singular Value Decomposition (SVD) during whitening. This can improve memory efficiency for intermediate datasets. Default is \code{TRUE}.}

\item{eps}{A numeric value specifying the convergence threshold. Default is \code{1e-6}.}

\item{maxit}{An integer specifying the maximum number of iterations for Sparse ICA. Default is 500.}

\item{BIC_plot}{A logical value indicating whether to generate a plot of BIC values for different \code{nu} candidates when selecting \code{nu}. Default is \code{TRUE}.}

\item{nu_list}{A numeric vector specifying candidate values for \code{nu} when selecting it using a BIC-like criterion. Default is \code{seq(0.1, 4, 0.05)}.}

\item{verbose}{A logical value indicating whether to print progress messages. Default is \code{TRUE}.}

\item{BIC_verbose}{A logical value indicating whether to print detailed messages during the BIC-based selection of \code{nu}. Default is \code{FALSE}.}

\item{converge_plot}{A logical value indicating whether to generate a plot showing the convergence trace during Sparse ICA. Default is \code{FALSE}.}
}
\value{
A list containing the results of the group Sparse ICA analysis, including:
\describe{
  \item{\code{loglik}}{The minimal log-likelihood value among the random initializations.}
  \item{\code{estS}}{A numeric matrix of estimated sparse independent components with dimensions P x Q.}
  \item{\code{estU}}{The estimated U matrix with dimensions Q x Q.}
  \item{\code{whitener}}{The whitener matrix used for data whitening.}
  \item{\code{converge}}{The trace of convergence for the U matrix.}
  \item{\code{best_nu}}{The selected \code{nu} value (if \code{nu = "BIC"}).}
  \item{\code{BIC}}{A numeric vector of BIC values for each \code{nu} candidate (if \code{nu = "BIC"}).}
  \item{\code{nu_list}}{The list of \code{nu} candidates used in the BIC-based selection (if \code{nu = "BIC"}).}
}
}
\description{
This function performs Sparse ICA on group-level fMRI data. It processes BIDS-formatted fMRI datasets, performs PCA to reduce dimensionality, selects a tuning parameter \code{nu} (optionally using a BIC-like criterion), and executes Sparse ICA to estimate independent components.
}
\details{
The function operates in four main steps:
\enumerate{
  \item If \code{subj_list} is not provided, it creates a list of subject-specific fMRI files using \code{\link{create_group_list}}.
  \item Performs subject-level PCA using \code{\link{gen_groupPC}} to reduce data dimensionality.
  \item Selects the tuning parameter \code{nu} using a BIC-like criterion (if \code{nu = "BIC"}) or uses the provided \code{nu}.
  \item Executes Sparse ICA on the group-level PCs to estimate independent components.
}
}
\seealso{
\code{\link{create_group_list}}, \code{\link{gen_groupPC}}, \code{\link{BIC_sparseICA}}, \code{\link{sparseICA}}
}
