% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_cell_annotations.R
\name{create_cell_annotations}
\alias{create_cell_annotations}
\title{Create Cell Type and Time Point Annotations for Heatmap Columns}
\usage{
create_cell_annotations(
  exp_mat,
  percent_mat,
  split_pattern = "_",
  time_position = 1,
  celltype_start = 2,
  time_points_order = NULL,
  cell_types_order = NULL,
  time_color_palette = "Accent",
  celltype_color_palette = "Dark2",
  show_time_annotation = TRUE,
  show_celltype_annotation = TRUE,
  time_point_title = "Time Point",
  cell_type_title = "Cell Type"
)
}
\arguments{
\item{exp_mat}{Expression matrix with samples as columns}

\item{percent_mat}{Percentage matrix with samples as columns}

\item{split_pattern}{Character string used to split column names (default: "_")}

\item{time_position}{Integer indicating position of time point in split names (default: 1)}

\item{celltype_start}{Integer indicating starting position of cell type in split names (default: 2)}

\item{time_points_order}{Character vector specifying order of time points (default: NULL for automatic)}

\item{cell_types_order}{Character vector specifying order of cell types (default: NULL for automatic)}

\item{time_color_palette}{Character string specifying palette name OR character vector of colors for time points (default: "Accent")}

\item{celltype_color_palette}{Character string specifying palette name OR character vector of colors for cell types (default: "Dark2")}

\item{show_time_annotation}{Logical indicating whether to show time point annotation (default: TRUE)}

\item{show_celltype_annotation}{Logical indicating whether to show cell type annotation (default: TRUE)}

\item{time_point_title}{Character string for time point annotation title (default: "Time Point")}

\item{cell_type_title}{Character string for cell type annotation title (default: "Cell Type")}
}
\value{
A list containing exp_mat_ordered (reordered expression matrix), percent_mat_ordered (reordered percentage matrix), col_annotation (ComplexHeatmap column annotation object), col_split_factor (factor for column splitting based on time points), and annotation_df (data frame with column annotations).
}
\description{
Parses column names to extract time points and cell types, creates annotations and reorders matrices.
}
\examples{
# Load a small example Seurat object
data("pbmc_small", package = "SeuratObject")
pbmc_small$timepoint <- sample(c("0h", "6h"), ncol(pbmc_small), replace = TRUE)
pbmc_small$timepoint_celltype <- paste(pbmc_small$timepoint, pbmc_small$RNA_snn_res.0.8, sep = "_")
features <- c("CD3D", "CD79A", "MS4A1")

# Prepare expression matrices first
matrices <- prepare_expression_matrices(pbmc_small, features, group_by = "timepoint_celltype")

# Create cell annotations with custom ordering
col_annotations <- create_cell_annotations(
  exp_mat = matrices$exp_mat,
  percent_mat = matrices$percent_mat,
  split_pattern = "_",
  time_points_order = c("0h", "6h"),
  cell_types_order = levels(pbmc_small$RNA_snn_res.0.8)
)

# Access results
ordered_exp_mat <- col_annotations$exp_mat_ordered

}
\seealso{
\code{\link{create_single_cell_complex_heatmap}}, \code{\link{prepare_expression_matrices}}
}
