% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_grid.R
\name{confidence_grid}
\alias{confidence_grid}
\title{confidence_grid}
\usage{
confidence_grid(
  alpha,
  lower_bds,
  upper_bds,
  seeds,
  generating_fun,
  s_obs,
  tol,
  resolution,
  theta_init = NULL,
  T_stat = ma_depth
)
}
\arguments{
\item{alpha}{A numeric representing the significance level of the test.}

\item{lower_bds}{A vector containing the lower bounds for the parameter search space.}

\item{upper_bds}{A vector containing the upper bounds for the parameter search space.}

\item{seeds}{A matrix (or array) of seeds for generating artificial statistics.}

\item{generating_fun}{A function that takes the random seeds above and a parameter in the search space as inputs to generate artificial statistics.}

\item{s_obs}{A vector representing the observed statistic.}

\item{tol}{A numeric specifying the tolerance of the confidence interval.}

\item{resolution}{An integer specifying the mesh number of the search space.}

\item{theta_init}{A vector specifying the starting point for the initial \code{optim} search.}

\item{T_stat}{Default to the Mahalanobis distance. See Vignette for detailed explanation.}
}
\value{
A list containing an indicator array (\code{ind_array}) representing the confidence set, the confidence set lower bounds (\code{updated_lower_bds}), and the confidence set upper bounds (\code{updated_upper_bds}).
}
\description{
returns the indicator array
}
\examples{
### Note that the examples may take a few seconds to run.
### Regular normal
set.seed(123)
n <- 50 # sample size
R <- 50 # Repro sample size (should be at least 200 for accuracy in practice)
alpha <- .05 # significance level
tol <- 0.01 # tolerance for the confidence set (use smaller tolerance in practice)
s_obs <- c(1.12, 0.67) # the observed sample mean
seeds <- matrix(rnorm(R * (n + 2)), nrow = R, ncol = n + 2) # pre-generated seeds

# this function computes the repro statistics given the seeds and the parameter
s_sample <- function(seeds, theta) {
  # generate the raw data points
  raw_data <- theta[1] + sqrt(theta[2]) * seeds[, 1:n]

  # compute the regular statistics
  s_mean <- apply(raw_data, 1, mean)
  s_var <- apply(raw_data, 1, var)

  return(cbind(s_mean, s_var))
}

lower_bds <- c(0.5, 0.3) # lower bounds for the parameter search region
upper_bds <- c(1.5, 1.3) # upper bounds for the parameter search region

resolution = 10  # resolution of the grid
result <- confidence_grid(alpha, lower_bds, upper_bds, seeds, s_sample, s_obs, tol, resolution)
print(result$ind_array)
print(result$search_lower_bds)
print(result$search_upper_bds)

}
