% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_function.r
\name{wrap_function}
\alias{wrap_function}
\title{Full ShellChron workflow wrapped in a single function}
\usage{
wrap_function(
  path = getwd(),
  file_name,
  transfer_function = "KimONeil97",
  t_int = 1,
  T_per = 365,
  d18Ow = 0,
  t_maxtemp = 182.5,
  SCEUApar = c(1, 25, 10000, 5, 0.01, 0.01),
  sinfit = TRUE,
  MC = 1000,
  plot = TRUE,
  plot_export = TRUE,
  export_raw = FALSE,
  export_path = getwd()
)
}
\arguments{
\item{path}{String containing the path to the directory
that contains the input data.}

\item{file_name}{Name of the file that contains d18O data}

\item{transfer_function}{String containing the name of the
transfer function. Defaults to Kim and O'Neil, 1997.}

\item{t_int}{Time interval (in days; default = 1)}

\item{T_per}{Period of SST sinusoid (in days;
default = 365)}

\item{d18Ow}{Either a single value (constant d18Ow)
or a vector of length equal to the period in SST data
(365 days by default) containing information about
seasonality in d18Ow. Defaults to constant d18Ow of
0 permille VSMOW (the modern mean ocean value)}

\item{t_maxtemp}{Timing of the warmest day of the year
(in julian day; default = 182.5, or May 26th halfway
through the year)}

\item{SCEUApar}{Parameters for SCEUA optimization (iniflg, ngs, maxn, kstop
pcento, peps) For details, refer to Duan et al. (1992) in references}

\item{sinfit}{Apply sinusoidal fitting to guess initial parameters for SCEUA
optimization? \code{TRUE/FALSE}}

\item{MC}{Number of Monte Carlo simulations to apply for
error propagation. Default = 1000}

\item{plot}{Should an overview of the results of modeling
be plotted? \code{TRUE/FALSE}}

\item{plot_export}{Should the overview plot be exported as
a PDF file? \code{TRUE/FALSE}}

\item{export_raw}{Export tables containing all raw model
results before being merged into tidy tables? \code{TRUE/FALSE}}

\item{export_path}{Path where result files are exported}
}
\value{
CSV tables of model results in the current working
directory, optional plots in PDF format and list object of
model results for further processing in the R workspace.
}
\description{
Takes starting parameters and names of input files
and directory and runs through all the steps of the
ShellChron model. Function includes options for plotting
and exporting raw data, which are parsed into underlying
formulae.
}
\examples{
# find attached dummy data
\donttest{example <- wrap_function(path = getwd(),
    file_name = system.file("extdata", "Virtual_shell.csv",
    package = "ShellChron"),
    transfer_function = "KimONeil97",
    t_int = 1,
    T_per = 365,
    d18Ow = 0,
    t_maxtemp = 182.5,
    SCEUApar = c(1, 25, 10000, 5, 0.01, 0.01),
    sinfit = TRUE,
    MC = 1000,
    plot = FALSE,
    plot_export = FALSE,
    export_raw = FALSE,
    export_path = tempdir())} # Run function
}
\references{
function dependencies: data_import, run_model, cumulative_day,
export_results
}
