% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence.R
\name{confidence_functionals}
\alias{confidence_functionals}
\title{Confidence functionals from a c0 grid}
\usage{
confidence_functionals(
  x,
  pi_thr = NULL,
  q = c(0.5, 0.8, 0.9),
  weight_fun = NULL,
  conservative = FALSE,
  B = NULL,
  method = c("trapezoid", "step")
)
}
\arguments{
\item{x}{An object from \code{sb_gamlss_c0_grid()}.}

\item{pi_thr}{Stability threshold; defaults to \code{x$pi_thr}.}

\item{q}{Numeric vector of quantiles to compute (in 0..1).}

\item{weight_fun}{Optional function w(c0) for weighted AUSC; default uniform.}

\item{conservative}{If TRUE, use Wilson lower confidence bounds for proportions.}

\item{B}{Number of bootstraps (if not inferable when conservative = TRUE).}

\item{method}{Integration method: "trapezoid" (default) or "step".}
}
\value{
A data.frame with per-term summaries, classed as \code{"sb_confidence"}.
}
\description{
Summarize selection proportions across c0 (SelectBoost threshold) into
single-number confidence scores per term/parameter.
}
