% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_helpers.R
\name{compare_table}
\alias{compare_table}
\title{Merge single-run results and bootstrap frequencies}
\usage{
compare_table(single_tab, freq_tab = NULL)
}
\arguments{
\item{single_tab}{Data frame returned in \code{compare_selectors_single()[["table"]]}.}

\item{freq_tab}{Optional frequency table from \code{\link[=compare_selectors_bootstrap]{compare_selectors_bootstrap()}}.}
}
\value{
Merged data frame.
}
\description{
Merge single-run results and bootstrap frequencies
}
\examples{
single_tab <- data.frame(
  selector = rep(c("AIC", "BIC"), each = 3),
  variable = rep(paste0("x", 1:3), times = 2),
  coef = c(0.5, 0, -0.2, 0.6, 0.1, -0.3)
)
single_tab$selected <- single_tab$coef != 0
freq_tab <- data.frame(
  selector = rep(c("AIC", "BIC"), each = 3),
  variable = rep(paste0("x", 1:3), times = 2),
  freq = c(0.9, 0.15, 0.4, 0.85, 0.3, 0.25)
)
compare_table(single_tab, freq_tab)
}
