% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_helpers.R
\name{compare_selectors_bootstrap}
\alias{compare_selectors_bootstrap}
\title{Bootstrap selection frequencies across selectors}
\usage{
compare_selectors_bootstrap(X, Y, B = 50, include_enet = TRUE, seed = NULL)
}
\arguments{
\item{X}{Numeric matrix (n × p) of mean-submodel predictors.}

\item{Y}{Numeric response in (0,1). Values are squeezed to (0,1) internally.}

\item{B}{Number of bootstrap replications.}

\item{include_enet}{Logical; include ENet if \code{gamlss.lasso} is installed.}

\item{seed}{Optional RNG seed.}
}
\value{
Long data frame with columns \code{selector}, \code{variable}, \code{freq} in \verb{[0,1]},
\code{n_success}, and \code{n_fail}. The \code{freq} column reports the share of bootstrap
replicates where a variable was selected by the corresponding selector.
Values near 1 signal high stability whereas small values indicate weak
evidence. \code{n_success} counts the successful fits contributing to the
frequency estimate (excluding failed replicates), while \code{n_fail} records the
number of unsuccessful fits. A \code{"failures"} attribute attached to the
returned data frame lists the replicate indices and messages for any
encountered errors.
}
\description{
Bootstraps the dataset \code{B} times and records how often each variable is
selected by each selector. Observations containing \code{NA} in either \code{X} or \code{Y}
are removed prior to resampling. Column names are abbreviated internally and
mapped back to the originals in the output just like in
\code{\link[=compare_selectors_single]{compare_selectors_single()}}.
}
\examples{
set.seed(1)
X <- matrix(rnorm(300), 100, 3); Y <- plogis(X[, 1])
Y <- rbeta(100, Y * 30, (1 - Y) * 30)
freq <- compare_selectors_bootstrap(X, Y, B = 10, include_enet = FALSE)
head(freq)
subset(freq, freq > 0.8)

\donttest{
# Increase B until the reported frequencies stabilise. For example,
freq_big <- compare_selectors_bootstrap(X, Y, B = 200, include_enet = FALSE)
stats::aggregate(freq ~ selector, freq_big, summary)
}

}
