% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy.R
\name{get_legacy_achievements}
\alias{get_legacy_achievements}
\title{Legacy API - Available Achievements}
\usage{
get_legacy_achievements(region_id, host_region = "us")
}
\arguments{
\item{region_id}{A numeric argument indicating the region of the profile.
    \itemize{
        \item 1 = US Region
        \item 2 = EU Region
        \item 3 = KR/TW Region
        \item 5 = CN Region
}}

\item{host_region}{The host region that the API call will be sent to. For most API calls, the same data will be
returned regardless of which region the request is sent to. Must be one of "us", "eu", "kr", "tw", "cn". For more
information on regionality, refer to
\href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}.}
}
\description{
Provides a listing of available achievements in Starcraft II.
}
\note{
Legacy API call. It is recommended to use \code{\link{get_static}} instead.
}
\references{
\itemize{
   \item \href{https://develop.battle.net/documentation/starcraft-2/community-apis}{Blizzard Community API Documentation}
   \item \href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}
   }
}
\seealso{
\code{\link{get_static}}

Other legacy API calls: 
\code{\link{get_legacy_ladders}()},
\code{\link{get_legacy_ladder}()},
\code{\link{get_legacy_match_history}()},
\code{\link{get_legacy_profile}()},
\code{\link{get_legacy_rewards}()}
}
\concept{legacy API calls}
