% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneandtrain.R
\name{tuneandtrain}
\alias{tuneandtrain}
\title{Tune and Train Classifier}
\usage{
tuneandtrain(data, dataext = NULL, tuningmethod, classifier, ...)
}
\arguments{
\item{data}{A data frame containing the training data. The first column should be the response variable, 
which must be a factor for classification tasks. The remaining columns should be the predictor variables. 
Ensure that the data is properly formatted, with no missing values.}

\item{dataext}{A data frame containing the external validation data, required only for the tuning methods 
"robusttunec" and "ext". Similar to the `data` argument, the first column should be the response variable (factor), 
and the remaining columns should be the predictors. If `tuningmethod = "int"`, this parameter is ignored.}

\item{tuningmethod}{A character string specifying which tuning approach to use. Options are:
\itemize{
  \item "robusttunec": Uses robust tuning that combines internal and external validation for parameter selection.
  \item "ext": Uses external validation data for tuning the parameters.
  \item "int": Internal cross-validation is used to tune the parameters without any external data.
}}

\item{classifier}{A character string specifying which classifier to use. Options include:
\itemize{
  \item "boosting": Boosting algorithms for improving weak classifiers.
  \item "rf": Random Forest for robust decision tree-based models.
  \item "lasso": Lasso regression for feature selection and regularization.
  \item "ridge": Ridge regression for regularization.
  \item "svm": Support Vector Machines for high-dimensional classification.
}}

\item{...}{Additional parameters to be passed to the specific tuning and training functions. These can include 
options such as the number of trees for Random Forest, the number of folds for cross-validation, or hyperparameters 
specific to the chosen classifier.}
}
\value{
A list containing the results of the tuning and training process, which typically includes:
\itemize{
  \item Best hyperparameters selected during the tuning process.
  \item The final trained model.
  \item Performance metrics (AUC) on the training or validation data, depending on the tuning method.
}
}
\description{
This function tunes and trains a classifier using a specified tuning method. Depending on the method chosen, 
the function will either perform RobustTuneC, external tuning, or internal tuning.
}
\examples{
# Load sample data
data(sample_data_train)
data(sample_data_extern)

# Example usage: Robust tuning with Ridge classifier
result_boosting <- tuneandtrain(sample_data_train, sample_data_extern, 
  tuningmethod = "robusttunec", classifier = "ridge")
result_boosting$best_lambda
result_boosting$best_model
result_boosting$final_auc

# Example usage: Internal cross-validation with Lasso classifier
result_lasso <- tuneandtrain(sample_data_train, tuningmethod = "int", 
  classifier = "lasso", maxit = 120000, nlambda = 200, nfolds = 5)
result_lasso$best_lambda
result_lasso$best_model
result_lasso$final_auc
result_lasso$active_set_Train
}
