% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastmve.R
\name{fastmve}
\alias{fastmve}
\title{Minimum Volume Ellipsoid covariance estimator}
\usage{
fastmve(x, nsamp = 500)
}
\arguments{
\item{x}{data matrix (n x p) with cases stored in rows.}

\item{nsamp}{number of random starts for the iterative algorithm, these
are constructed using subsamples of the data.}
}
\value{
A list with the following components:
\item{center}{a vector with the robust multivariate location estimate}
\item{cov}{a matrix with the robust covariance / scatter matrix estimate}
\item{scale}{A scalar that equals the median of the mahalanobis distances of the
data to the \code{center}, multiplied by the determinant of the covariance matrix
to the power 1/p}
\item{best}{Indices of the observations that correspond to the MVE estimator}
\item{nsamp}{Number of random starts used for the iterative algorithm}
\item{nsing}{Number of random subsamples (among the \code{nsamp} attempted)
that failed (resulting in singular initial values)}
}
\description{
This function uses a fast algorithm to compute the Minimum Volume
Ellipsoid (MVE) for multivariate location and scatter.
}
\details{
This function computes the Minimum Volume
Ellipsoid (MVE) for multivariate location and scatter, using a
fast algorithm related to the fast algorithm for S-regression
estimators (see \code{\link[robustbase]{lmrob}}).
}
\examples{
data(bus)
X0 <- as.matrix(bus)
X1 <- X0[,-9]
tmp <- fastmve(X1)
round(tmp$cov[1:10, 1:10], 3)
tmp$center

}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\author{
Matias Salibian-Barrera, \email{matias@stat.ubc.ca}
}
