% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateRepo.r
\name{createDownloadText}
\alias{createDownloadText}
\title{createDownloadText}
\usage{
createDownloadText(info)
}
\arguments{
\item{info}{\link{data.frame} listing data sources. Must have at least the following columns: Local (the name the file should be on disk after downloaded), Remote (the URL of the file), Mode (the way to write to disk, either 'w' or 'wb').}
}
\value{
Returns the block of text
}
\description{
Builds text for file that downloads data
}
\details{
Creates a block of code. The first line is a comment of the file name, then is uses \code{\link[=download.file]{download.file()}} using the remote URL and the local filename.
}
\examples{

dataList <- read.csv(system.file('metadata/DataList.csv', package='RepoGenerator'), 
    stringsAsFactors=FALSE, header=TRUE)
cat(RepoGenerator:::createDownloadText(dataList))

}
\author{
Jared P. Lander
}
