set.seed(451)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),matrix(runif(20,20,30), nrow = 2, ncol = 10),matrix(runif(20,50,70), nrow = 2, ncol = 10))

#Our method
e1=kmedois_distance(data, Euclideandistance,  k=3)
sil_e1=e1$Quality[1]
names(sil_e1)<-NULL
centers_e1=e1$Output_of_grouping$centers
grouping_e1=e1$Output_of_grouping$grouping
vector=c()
for (ii in 1:dim(data)[1]){
  vector[ii]=encontrar_componente(grouping_e1, ii)
}

#Method implemented
dissG <- proxy::dist(data, method = Euclideandistance)
pr<-cluster::pam(dissG, 3, stand = FALSE)

sil_pr=mean(pr$silinfo$widths[,3])
centers_pr=data[pr$medoids,]
grouping_pr=pr$clustering


#We make sure they are the same
test_that("Hartigan_and_Wong", {
  expect_equal(sil_e1,  sil_pr,tolerance=1e-6)
  expect_equal(centers_e1, centers_pr,tolerance=1e-6)
  expect_equal( vector, grouping_pr,tolerance=1e-6)
})

