% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_centers_hw.R
\name{init_centers_hw}
\alias{init_centers_hw}
\title{Initializing the centers}
\usage{
init_centers_hw(data, distance, k, centers_function)
}
\arguments{
\item{data}{Matrix with \code{dim(data)[1]} points of \code{dim(data)[2]} dimensions.}

\item{distance}{Function. This function designs how the distance is going to be calculated. It must have as input two vectors and as output the distance of these vectors.}

\item{k}{Number. Number of groups into which we are going to group the different points.}

\item{centers_function}{Function. This function designs how the centers of the groups will be calculated. It must have as input \code{data} and \code{grouping} and as output a matrix that has the centers. This matrix will have as many rows as centers. With \code{grouping} we mean a list. The list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.}
}
\value{
Returns a matrix where each row is the center of a group.
}
\description{
This function initializes the cluster centers following the procedure described in the ‘Additional Comments’ section of Hartigan and Wong (1979), without restricting the method to the use of Euclidean distance.
}
\examples{

set.seed(451)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),
          matrix(runif(20,20,30), nrow = 2, ncol = 10),
          matrix(runif(20,50,70), nrow = 2, ncol = 10))
k=3
seed=5

centr=init_centers_hw(data, Euclideandistance,k,centers_function_mean)


}
\references{
Hartigan, J. A., & Wong, M. A. (1979). Algorithm AS 136: A k-means clustering algorithm. Journal of the royal statistical society. series c (applied statistics), 28(1), 100-108.
}
