% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/things-properties.R
\name{things_properties}
\alias{things_properties}
\alias{things_properties_create}
\alias{things_properties_update}
\alias{things_properties_list}
\alias{things_properties_show}
\alias{things_properties_delete}
\title{Properties (of things) API methods}
\usage{
things_properties_create(
  thing_id,
  name,
  permission,
  type,
  update_strategy,
  ...,
  store_token = "option",
  token = NULL,
  silent = FALSE
)

things_properties_update(
  thing_id,
  property_id,
  name,
  permission,
  type,
  update_strategy,
  ...,
  store_token = "option",
  token = NULL,
  silent = FALSE
)

things_properties_list(
  thing_id,
  show_deleted = FALSE,
  store_token = "option",
  token = NULL,
  silent = FALSE
)

things_properties_show(
  thing_id,
  property_id,
  store_token = "option",
  token = NULL,
  silent = FALSE
)

things_properties_delete(
  thing_id,
  property_id,
  store_token = "option",
  token = NULL,
  silent = FALSE
)
}
\arguments{
\item{thing_id}{The id of the thing}

\item{name}{The friendly name of the property}

\item{permission}{The permission of the property (READ_ONLY or READ_WRITE allowed)}

\item{type}{The type of the property (see details for exhaustive list of values)}

\item{update_strategy}{The update strategy for the property value (ON_CHANGE or TIMED allowed)}

\item{...}{Optional parameters for \code{things_properties_create}:
\itemize{
\item \code{max_value} (numeric) Maximum value of this property
\item \code{min_value} (numeric) Minimum value of this property
\item \code{persist} (logic) If \code{TRUE}, data will persist into a timeseries database
\item \code{tag} (numeric) The integer id of the property
\item \code{update_parameter} (numeric) The update frequency in seconds, or the amount of the property
has to change in order to trigger an update
\item \code{variable_name} (character) The sketch variable name of the property
}}

\item{store_token}{Where your token is stored. If \code{option} it will be retrieved from the .Rprofile (not cross-session and default),
if \code{envir} it will be retrieved from environmental variables list (cross-session)}

\item{token}{A valid token created with \code{create_auth_token} or manually.
It not \code{NULL} it has higher priority then \code{store_token}.}

\item{silent}{Whether to hide or show API method success messages (default \code{FALSE})}

\item{property_id}{The id of the property}

\item{show_deleted}{If \code{TRUE}, shows the soft deleted properties. Default to \code{FALSE}}
}
\value{
A tibble showing information about chosen property or list of properties for given thing
}
\description{
Create, Update, List, Show and Delete properties associated to a given thing

Official documentation:
\itemize{
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-PropertiesV2-propertiesV2Create}{propertiesV2Create}
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-PropertiesV2-propertiesV2Update}{propertiesV2Update}
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-PropertiesV2-propertiesV2List}{propertiesV2List}
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-PropertiesV2-propertiesV2Show}{propertiesV2Show}
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-PropertiesV2-propertiesV2Delete}{propertiesV2Delete}
}
}
\examples{
\dontrun{
library(dplyr)

Sys.setenv(ARDUINO_API_CLIENT_ID = 'INSERT CLIENT_ID HERE')
Sys.setenv(ARDUINO_API_CLIENT_SECRET = 'INSERT CLIENT_SECRET HERE')
create_auth_token()

thing_id = "b6822400-2f35-4d93-b3e7-be919bdc5eba"

### create property ###
things_properties_create(thing_id = thing_id,
name = "test",  permission = "READ_ONLY", type = "FLOAT",
update_strategy = "ON_CHANGE", update_parameter = 10)

### check properties list ###
p_list = things_properties_list(thing_id = thing_id, show_deleted = FALSE)
property_id = p_list \%>\% filter(name == "test") \%>\% pull(id)

things_properties_show(thing_id = thing_id, property_id = property_id)

### update property ###
things_properties_update(thing_id = thing_id, property_id = property_id,
name = "test_update", permission = "READ_ONLY", type = "FLOAT",
update_strategy = "ON_CHANGE", update_parameter = 10)

### delete property ###
things_properties_delete(thing_id = thing_id, property_id = property_id)
}
}
