# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Simple RcppClock example
#' 
#' Time the computation of fibonacci numbers
#' 
#' @details
#' The function being timed is the following:
#'
#' \code{int fib(int n) { return ((n <= 1) ? n : fib(n - 1) + fib(n - 2)); }}
#' 
#' Runtime for computations less than \code{n = 25} is nearly unmeasurable.
#' 
#' @param n vector giving integers for which to compute the fibonacci sum
#' @param reps number of replicates for timing 
#' @export
#' @examples
#' fibonacci(n = c(25:35), reps = 10)
#' # this function creates a global environment variable "clock"
#' #   that is an S3 RcppClock object
#' clock
#' plot(clock)
#' summary(clock, units = "ms")
fibonacci <- function(n, reps = 10L) {
    invisible(.Call(`_RcppClock_fibonacci`, n, reps))
}

