% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-random-gamma-walk.R
\name{random_gamma_walk}
\alias{random_gamma_walk}
\title{Generate Multiple Random Gamma Walks in Multiple Dimensions}
\usage{
random_gamma_walk(
  .num_walks = 25,
  .n = 100,
  .shape = 1,
  .scale = 1,
  .rate = NULL,
  .initial_value = 0,
  .samp = TRUE,
  .replace = TRUE,
  .sample_size = 0.8,
  .dimensions = 1
)
}
\arguments{
\item{.num_walks}{An integer specifying the number of random walks to generate. Default is 25.}

\item{.n}{An integer specifying the number of steps in each walk. Must be greater than 0. Default is 100.}

\item{.shape}{A positive numeric value for the shape parameter. Default is 1.}

\item{.scale}{A positive numeric value for the scale parameter. Default is 1.}

\item{.rate}{A positive numeric value for the rate parameter. Default is NULL (ignored if scale is provided).}

\item{.initial_value}{A numeric value indicating the initial value of the walks. Default is 0.}

\item{.samp}{A logical value indicating whether to sample the gamma distribution values. Default is TRUE.}

\item{.replace}{A logical value indicating whether sampling is with replacement. Default is TRUE.}

\item{.sample_size}{A numeric value between 0 and 1 specifying the proportion of \code{.n} to sample. Default is 0.8.}

\item{.dimensions}{An integer specifying the number of dimensions (1, 2, or 3). Default is 1.}
}
\value{
A tibble containing the generated random walks with columns depending on the number of dimensions:
\itemize{
\item \code{walk_number}: Factor representing the walk number.
\item \code{step_number}: Step index.
\item \code{y}: If \code{.dimensions = 1}, the value of the walk at each step.
\item \code{x}, \code{y}: If \code{.dimensions = 2}, the values of the walk in two dimensions.
\item \code{x}, \code{y}, \code{z}: If \code{.dimensions = 3}, the values of the walk in three dimensions.
}

The following are also returned based upon how many dimensions there are and could be any of x, y and or z:
\itemize{
\item \code{cum_sum}: Cumulative sum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_prod}: Cumulative product of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_min}: Cumulative minimum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_max}: Cumulative maximum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_mean}: Cumulative mean of \code{dplyr::all_of(.dimensions)}.
}

The tibble includes attributes for the function parameters.
}
\description{
The \code{random_gamma_walk} function generates multiple random walks in 1, 2, or 3 dimensions.
Each walk is a sequence of steps where each step is a random draw from a gamma distribution.
The user can specify the number of walks, the number of steps in each walk, and the
parameters of the gamma distribution (shape, scale, rate). The function
also allows for sampling a proportion of the steps and optionally sampling with replacement.
}
\details{
This function is a flexible generator for random walks where each step is drawn from a gamma distribution.
The user can control the number of walks, steps per walk, and the shape, scale, and rate parameters for the distribution.
The function supports 1, 2, or 3 dimensions, and augments the output with cumulative statistics for each walk.
Sampling can be performed with or without replacement, and a proportion of steps can be sampled if desired.
}
\examples{
set.seed(123)
random_gamma_walk()

set.seed(123)
random_gamma_walk(.dimensions = 3) |>
  head() |>
  t()

}
\seealso{
Other Generator Functions: 
\code{\link{brownian_motion}()},
\code{\link{discrete_walk}()},
\code{\link{geometric_brownian_motion}()},
\code{\link{random_beta_walk}()},
\code{\link{random_binomial_walk}()},
\code{\link{random_cauchy_walk}()},
\code{\link{random_chisquared_walk}()},
\code{\link{random_displacement_walk}()},
\code{\link{random_exponential_walk}()},
\code{\link{random_f_walk}()},
\code{\link{random_geometric_walk}()},
\code{\link{random_hypergeometric_walk}()},
\code{\link{random_logistic_walk}()},
\code{\link{random_lognormal_walk}()},
\code{\link{random_multinomial_walk}()},
\code{\link{random_negbinomial_walk}()},
\code{\link{random_normal_drift_walk}()},
\code{\link{random_normal_walk}()},
\code{\link{random_poisson_walk}()},
\code{\link{random_smirnov_walk}()},
\code{\link{random_t_walk}()},
\code{\link{random_uniform_walk}()},
\code{\link{random_weibull_walk}()},
\code{\link{random_wilcox_walk}()},
\code{\link{random_wilcoxon_sr_walk}()}

Other Continuous Distribution: 
\code{\link{brownian_motion}()},
\code{\link{geometric_brownian_motion}()},
\code{\link{random_beta_walk}()},
\code{\link{random_cauchy_walk}()},
\code{\link{random_chisquared_walk}()},
\code{\link{random_exponential_walk}()},
\code{\link{random_f_walk}()},
\code{\link{random_logistic_walk}()},
\code{\link{random_lognormal_walk}()},
\code{\link{random_normal_drift_walk}()},
\code{\link{random_normal_walk}()},
\code{\link{random_t_walk}()},
\code{\link{random_uniform_walk}()},
\code{\link{random_weibull_walk}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Continuous Distribution}
\concept{Generator Functions}
