% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_matrix_kernels.R
\name{SparseCholeskyMicrobenchmark}
\alias{SparseCholeskyMicrobenchmark}
\title{Conducts a single performance trial with the Cholesky factorization
sparse matrix kernel}
\usage{
SparseCholeskyMicrobenchmark(benchmarkParameters, kernelParameters)
}
\arguments{
\item{benchmarkParameters}{an object of type
\code{\link{SparseMatrixMicrobenchmark}} specifying various parameters
for microbenchmarking the sparse matrix kernel}

\item{kernelParameters}{a list of matrices or vectors to be used as input to
the sparse matrix kernel}
}
\value{
a vector containing the user, system, and elapsed performance
  timings in that order
}
\description{
\code{SparseMatrixVectorMicrobenchmark} conducts a single performance trial
of the Cholesky factorization sparse matrix kernel for the matrix given in
the \code{kernelParameters} parameter.  The function times the single
function call \code{kernelParameters$A \%*\% kernelParameters$b}.
}
\examples{
\dontrun{
# Allocate input to the Cholesky factorization microbenchmark for the
# ct20stif matrix
microbenchmarks <- GetSparseCholeskyDefaultMicrobenchmarks()
kernelParameters <- SparseCholeskyAllocator(microbenchmarks[["cholesky_ct20stif"]], 1)
# Execute the microbenchmark
timings <- SparseCholeskyMicrobenchmark(
   microbenchmarks[["choleksy_ct20stif"]], kernelParameters)
}

}
