% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dense_matrix_kernels.R
\name{DeformtransMicrobenchmark}
\alias{DeformtransMicrobenchmark}
\title{Conducts a single performance trial with the matrix deformation and transpose
dense matrix kernel}
\usage{
DeformtransMicrobenchmark(benchmarkParameters, kernelParameters)
}
\arguments{
\item{benchmarkParameters}{an object of type
\code{\link{DenseMatrixMicrobenchmark}} specifying various parameters
for microbenchmarking the dense matrix kernel}

\item{kernelParameters}{a list of matrices or vectors to be used as input to
the dense matrix kernel}
}
\description{
\code{DeformtransMicrobenchmark} conducts a single performance trial of the
matrix deformation and transpose dense matrix kernel for the matrix given in
the \code{kernelParameters} parameter.  The function times the transposition
of the input matrix, resizing of the input matrix, and transposition of the
resized matrix.
}
\examples{
\dontrun{
# Allocate input to the matrix deformation and transpose microbenchmark for
# the first matrix size to be tested
microbenchmarks <- GetDenseMatrixDefaultMicrobenchmarks()
kernelParameters <- DeformtransAllocator(microbenchmarks[["deformtrans"]], 1)
# Execute the microbenchmark
timings <- DeformtransMicrobenchmark(microbenchmarks[["deformtrans"]], kernelParameters)
}

}
