% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoencoder_functions.R
\name{aseq2feature_seq2seq}
\alias{aseq2feature_seq2seq}
\title{Feature Extraction by action sequence autoencoder}
\usage{
aseq2feature_seq2seq(aseqs, K, rnn_type = "lstm", n_epoch = 50,
  method = "last", step_size = 1e-04, optimizer_name = "adam",
  samples_train, samples_valid, samples_test = NULL, pca = TRUE,
  verbose = TRUE, return_theta = TRUE)
}
\arguments{
\item{aseqs}{a list of \code{n} action sequences. Each element is an action
sequence in the form of a vector of actions.}

\item{K}{the number of features to be extracted.}

\item{rnn_type}{the type of recurrent unit to be used for modeling
response processes. \code{"lstm"} for the long-short term memory unit. 
\code{"gru"} for the gated recurrent unit.}

\item{n_epoch}{the number of training epochs for the autoencoder.}

\item{method}{the method for computing features from the output of an
recurrent neural network in the encoder. Available options are 
\code{"last"} and \code{"avg"}.}

\item{step_size}{the learning rate of optimizer.}

\item{optimizer_name}{a character string specifying the optimizer to be used
for training. Availabel options are \code{"sgd"}, \code{"rmsprop"}, 
\code{"adadelta"}, and \code{"adam"}.}

\item{samples_train}{vectors of indices specifying the
training, validation and test sets for training autoencoder.}

\item{samples_valid}{vectors of indices specifying the
training, validation and test sets for training autoencoder.}

\item{samples_test}{vectors of indices specifying the
training, validation and test sets for training autoencoder.}

\item{pca}{logical. If TRUE, the principal components of features are
returned. Default is TRUE.}

\item{verbose}{logical. If TRUE, training progress is printed.}

\item{return_theta}{logical. If TRUE, extracted features are returned.}
}
\value{
\code{aseq2feature_seq2seq} returns a list containing
  \item{theta}{a matrix containing \code{K} features or principal features. Each column is a feature.}
  \item{train_loss}{a vector of length \code{n_epoch} recording the trace of training losses.}
  \item{valid_loss}{a vector of length \code{n_epoch} recording the trace of validation losses.}
  \item{test_loss}{a vector of length \code{n_epoch} recording the trace of test losses. Exists only if \code{samples_test} is not \code{NULL}.}
}
\description{
\code{aseq2feature_seq2seq} extract features from action sequences by action
sequence autoencoder.
}
\details{
This function trains a sequence-to-sequence autoencoder using keras. The encoder
of the autoencoder consists of an embedding layer and a recurrent neural network.
The decoder consists of another recurrent neural network and a fully connect layer
with softmax activation. The outputs of the encoder are the extracted features.

The output of the encoder is a function of the encoder recurrent neural network.
It is the last output of the encoder recurrent neural network if \code{method="last"}
and the average of the encoder recurrent nenural network if \code{method="avg"}.
}
\examples{
\donttest{
if (!system("python -c 'import tensorflow as tf'", ignore.stdout = TRUE, ignore.stderr= TRUE)) {
  n <- 50
  seqs <- seq_gen(n)
  seq2seq_res <- aseq2feature_seq2seq(seqs$action_seqs, 5, rnn_type="lstm", n_epoch=5, 
                                   samples_train=1:40, samples_valid=41:50)
  features <- seq2seq_res$theta
  plot(seq2seq_res$train_loss, col="blue", type="l")
  lines(seq2seq_res$valid_loss, col="red")
}

}
}
\seealso{
\code{\link{chooseK_seq2seq}} for choosing \code{K} through cross-validation.

Other feature extraction methods: \code{\link{atseq2feature_seq2seq}},
  \code{\link{seq2feature_mds_large}},
  \code{\link{seq2feature_mds}},
  \code{\link{seq2feature_ngram}},
  \code{\link{seq2feature_seq2seq}},
  \code{\link{tseq2feature_seq2seq}}
}
\concept{feature extraction methods}
