% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDAR.beta.R
\name{CDaR.beta}
\alias{CDaR.beta}
\title{Conditional Drawdown beta}
\usage{
CDaR.beta(R, Rm, p = 0.95, weights = NULL, geometric = TRUE, type = NULL, ...)
}
\arguments{
\item{R}{an xts, vector, matrix, data frame, timeSeries or zoo object of 
asset returns}

\item{Rm}{an xts, vector, matrix, data frame, timeSeries or zoo object of benchmark returns}

\item{p}{confidence level for calculation ,default(p=0.95)}

\item{weights}{portfolio weighting vector, default NULL, see Details}

\item{geometric}{utilize geometric chaining (TRUE) or simple/arithmetic 
chaining (FALSE) to aggregate returns, default TRUE}

\item{type}{(Optional) Overrides the p parameter. If "average" then p = 0 and if "max" then p = 1}

\item{\dots}{any passthru variable.}
}
\description{
The conditional drawdown beta is a measure of capturing performance under market drawdowns and it is given by
the ratio of  the average rate of return of the instrument over time periods corresponding to the \eqn{(1-p)T} 
largest drawdowns of the benchmark portfolio.

The difference in CDaR and standard beta boils down to the fact that the standard beta accounts 
for the fund returns over the whole return history, including the upside 
while CDaR beta focuses only on market drawdowns.
}
\examples{
data(edhec)
CDaR.beta(edhec[,1],edhec[,2]) 
CDaR.beta(edhec[,1],edhec[,2],type="max")
CDaR.beta(edhec[,1],edhec[,2],type="average")
}
\references{
Zabarankin, M., Pavlikov, K., and S. Uryasev. Capital Asset Pricing Model 
(CAPM) with Drawdown Measure.Research Report 2012-9, ISE Dept., University 
of Florida,September 2012.
}
\seealso{
\code{\link{CDaR.alpha}}  \code{\link{CDaR}}
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>,Pulkit Mehrotra
}
