% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quanti.R
\name{quanti}
\alias{quanti}
\title{Step by step: the model develops driven by field data}
\usage{
quanti(
  origin = NA,
  step_name,
  crop,
  proportion = TRUE,
  equal_dis = TRUE,
  res_max = NA,
  res_min = 0,
  formul = NA,
  area,
  addit_variables = NA,
  log_values = TRUE,
  back_log = TRUE
)
}
\arguments{
\item{origin}{numbers or log-numbers of individuals at the start for every genotype. \code{numeric}. Alternatively the columnaes of dfgenotype can be used.}

\item{step_name}{step name in the database containing the model parameters. \code{character}.}

\item{crop}{current crop in the crop sequence, must fit to one of the crop names in the data frame with weed-parameters. \code{character}.}

\item{proportion}{\code{logical}, \code{TRUE} when the output should be a proportion, otherwise it will be an absolute number.}

\item{equal_dis}{\code{logical}, \code{TRUE} when the distribution of the weeds is spatially uniform across the \code{area}.}

\item{res_max}{output maximum, ignored when \code{origin=NA}. \code{numeric}.}

\item{res_min}{output minimum. \code{numeric}.}

\item{formul}{\code{character}. See details.}

\item{area}{number of area units. \code{positive numeric}.}

\item{addit_variables}{variables used in \code{formul} that are not predefined in \code{param.weed}. See details. \code{character vector}}

\item{log_values}{logical, \code{TRUE} when \code{origin} in log-scale.}

\item{back_log}{logical, \code{TRUE} when the output is in log-scale. Only used when \code{proportion==FALSE}.}
}
\value{
Either a (log-)number of individuals or a proportion resp. a rate.
}
\description{
This is a working horse of PROSPER. It quantifies the number or the proportion of individuals entering the next development stage using predefined formulas (\code{formul}). Typically these formulas are the results of experiments.
}
\details{
Within PROSPER simulation models are build up with discrete simulation steps. These steps are conducted by functions like \code{pop_step} or \code{gen_reprod}. These functions affect the complete population and need a count of individuals or a proportion of the population that are affected of the specific simulation step. These numbers are calculated with \code{quanti}. The calculation is based on the data provided in \code{\link{weed-parameters}}. There a model is given for every parameter in the table. The parameter \code{formul} allows to use a different model if necessary. If no model is given at all, the simulation step is assumed to consist only of one value. The parameters of \code{param.weed} are normal distributed and the SE is used to draw them for the current calculation using \code{rnorm()}. These values are used to evaluate the model for simulation step. The resulting count or proportion can be used to perform the simulation step for the population.
}
\examples{
#loads the example data for Echinochloa crus-galli
data(param.ECHCG)
param.weed <- param.ECHCG
#how many seeds (natural, not log-scale) prodused by 100 plants in a corn stand on 100 area units?
quanti(origin=100, step_name="seed_prod_first", crop="corn",  proportion=FALSE,
                 area=100, log_values=FALSE, back_log=FALSE)
rm(param.ECHCG)
}
\seealso{
\code{\link{pop_step}} \code{\link{pop_germc}} \code{\link{weed-parameters}}
}
