% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rPLN}
\alias{rPLN}
\title{PLN RNG}
\usage{
rPLN(
  n = 10,
  mu = rep(0, ncol(Sigma)),
  Sigma = diag(1, 5, 5),
  depths = rep(10000, n)
)
}
\arguments{
\item{n}{the sample size}

\item{mu}{vectors of means of the latent variable}

\item{Sigma}{covariance matrix of the latent variable}

\item{depths}{Numeric vector of target depths. The first is recycled if there are not \code{n} values}
}
\value{
a n * p count matrix, with row-sums close to depths, with an attribute "offsets"
corresponding to the true generated offsets (in log-scale).
}
\description{
Random generation for the PLN model with latent mean equal to mu, latent covariance matrix
equal to Sigma and average depths (sum of counts in a sample) equal to depths
}
\details{
The default value for mu and Sigma assume equal abundances and no correlation between
the different species.
}
\examples{
## 10 samples of 5 species with equal abundances, no covariance and target depths of 10,000
rPLN()
## 2 samples of 10 highly correlated species with target depths 1,000 and 100,000
## very different abundances
mu <- rep(c(1, -1), each = 5)
Sigma <- matrix(0.8, 10, 10); diag(Sigma) <- 1
rPLN(n=2, mu = mu, Sigma = Sigma, depths = c(1e3, 1e5))

}
