% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compute_PLN_starting_point}
\alias{compute_PLN_starting_point}
\title{Helper function for PLN initialization.}
\usage{
compute_PLN_starting_point(Y, X, O, w, s = 0.1)
}
\arguments{
\item{Y}{Response count matrix}

\item{X}{Covariate matrix}

\item{O}{Offset matrix (in log-scale)}

\item{w}{Weight vector (defaults to 1)}

\item{s}{Scale parameter for S (defaults to 0.1)}
}
\value{
a named list of starting values for model parameter B and variational parameters M and S used in the iterative optimization algorithm of \code{\link[=PLN]{PLN()}}
}
\description{
Barebone function to compute starting points for B, M and S when fitting a PLN. Mostly intended for internal use.
}
\details{
The default strategy to estimate B and M is to fit a linear model with covariates \code{X} to the response count matrix (after adding a pseudocount of 1, scaling by the offset and taking the log). The regression matrix is used to initialize \code{B} and the residuals to initialize \code{M}. \code{S} is initialized as a constant conformable matrix with value \code{s}.
}
\examples{
\dontrun{
data(barents)
Y <- barents$Abundance
X <- model.matrix(Abundance ~ Latitude + Longitude + Depth + Temperature, data = barents)
O <- log(barents$Offset)
w <-- rep(1, nrow(Y))
compute_PLN_starting_point(Y, X, O, w)
}

}
