% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZIPLNnetwork.R
\name{ZIPLNnetwork_param}
\alias{ZIPLNnetwork_param}
\title{Control of ZIPLNnetwork fit}
\usage{
ZIPLNnetwork_param(
  backend = c("nlopt"),
  inception_cov = c("full", "spherical", "diagonal"),
  trace = 1,
  n_penalties = 30,
  min_ratio = 0.1,
  penalize_diagonal = TRUE,
  penalty_weights = NULL,
  config_post = list(),
  config_optim = list(),
  inception = NULL
)
}
\arguments{
\item{backend}{optimization back used, either "nlopt" or "torch". Default is "nlopt"}

\item{inception_cov}{Covariance structure used for the inception model used to initialize the PLNfamily. Defaults to "full" and can be constrained to "diagonal" and "spherical".}

\item{trace}{a integer for verbosity.}

\item{n_penalties}{an integer that specifies the number of values for the penalty grid when internally generated. Ignored when penalties is non \code{NULL}}

\item{min_ratio}{the penalty grid ranges from the minimal value that produces a sparse to this value multiplied by \code{min_ratio}. Default is 0.1.}

\item{penalize_diagonal}{boolean: should the diagonal terms be penalized in the graphical-Lasso? Default is \code{TRUE}}

\item{penalty_weights}{either a single or a list of p x p matrix of weights (default: all weights equal to 1) to adapt the amount of shrinkage to each pairs of node. Must be symmetric with positive values.}

\item{config_post}{a list for controlling the post-treatment (optional bootstrap, jackknife, R2, etc).}

\item{config_optim}{a list for controlling the optimizer (either "nlopt" or "torch" backend). See details}

\item{inception}{Set up the parameters initialization: by default, the model is initialized with a multivariate linear model applied on
log-transformed data, and with the same formula as the one provided by the user. However, the user can provide a PLNfit (typically obtained from a previous fit),
which sometimes speeds up the inference.}
}
\value{
list of parameters configuring the fit.
}
\description{
Helper to define list of parameters to control the ZIPLNnetwork fit. All arguments have defaults.
}
\details{
See \code{\link[=PLNnetwork_param]{PLNnetwork_param()}} for a full description of the optimization parameters. Note that some defaults values are different than those used in \code{\link[=PLNnetwork_param]{PLNnetwork_param()}}:
\itemize{
\item "ftol_out" (outer loop convergence tolerance the objective function) is set by default to 1e-6
\item "maxit_out" (max number of iterations for the outer loop) is set by default to 100
}
}
\seealso{
\code{\link[=PLNnetwork_param]{PLNnetwork_param()}} and \code{\link[=PLN_param]{PLN_param()}}
}
