% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{retrieve_one}
\alias{retrieve_one}
\title{Retrieve single instance.}
\usage{
retrieve_one(url, default = stop("value not found"), ...)
}
\arguments{
\item{url}{Which url to fetch data from}

\item{default}{The default if nothing was found.
If not specified, an error is thrown in this case.}

\item{...}{
  Arguments passed on to \code{\link[=retrieve_data]{retrieve_data}}
  \describe{
    \item{\code{metadata}}{Whether and how metadata is included}
    \item{\code{httr_args}}{List of additional arguments passed on to httr::GET}
    \item{\code{jsonlite_args}}{List of additional arguments passed on to jsonlite::fromJSON}
  }}
}
\value{
Single value or default if none. If the result consists of
multiple records, an error is thrown.
}
\description{
Retrieve single instance.
}
\examples{
\dontrun{
url <- "https://services.odata.org/V4/TripPinServiceRW/People?$top=1"
retrieve_one(url)

url <- "https://services.odata.org/V4/TripPinServiceRW/People('russellwhyte')"
retrieve_one(url)
}
}
\seealso{
Other retrieve: 
\code{\link{odata_function}()},
\code{\link{retrieve_all}()},
\code{\link{retrieve_data}()}
}
\concept{retrieve}
