% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_confusion_matrix.R
\name{rm_confusion_matrix}
\alias{rm_confusion_matrix}
\title{A result metric (RM) that calculates confusion matrices}
\usage{
rm_confusion_matrix(
  ndr_container_or_object = NULL,
  save_TCD_results = FALSE,
  create_decision_vals_confusion_matrix = TRUE
)
}
\arguments{
\item{ndr_container_or_object}{The purpose of this argument is to make the
constructor of the rm_confusion_matrix feature preprocessor work with the
magrittr pipe (|>) operator. This argument should almost never be directly
set by the user to anything other than NULL. If this is set to the default
value of NULL, then the constructor will return a rm_confusion_matrix
object. If this is set to an ndr container, then a rm_confusion_matrix
object will be added to the container and the container will be returned.
If this argument is set to another ndr object, then both that ndr object as
well as a new rm_confusion_matrix object will be added to a new container
and the container will be returned.}

\item{save_TCD_results}{A Boolean specifying whether one wants
to save results to allow one to create temporal cross decoding confusion
matrices; i.e., confusion matrices when training at one point in time and
testing a different point in time. Setting this to FALSE can save memory.}

\item{create_decision_vals_confusion_matrix}{A boolean specifying whether one
wants to create a confusion matrix of the decision values. In this
confusion matrix, each row corresponds to the correct class (like a regular
confusion matrix) and each column corresponds to the mean decision value of
the predictions for each class.}
}
\value{
This constructor creates an NDR result metric object with the class
\code{rm_confusion_matrix}. Like all NDR result metric objects, this result
metric will be used by a cross-validator to create a measure of decoding
accuracy by aggregating the results after all cross-validation splits have
been run, and after all resample runs have completed.
}
\description{
This result metric calculate a confusion matrices from all points in time.
}
\details{
Like all result metrics, this result metric has functions to aggregate
results after completing each set of cross-validation classifications, and
also after completing all the resample runs. The results should then be
available in the DECODING_RESULTS object returned by the cross-validator.
}
\examples{
# If you only want to use the rm_confusion_matrix(), then you can put it in a
# list by itself and pass it to the cross-validator.
the_rms <- list(rm_confusion_matrix())


}
\seealso{
Other result_metrics: 
\code{\link{plot.rm_confusion_matrix}()},
\code{\link{plot.rm_main_results}()},
\code{\link{plot_main_results}()},
\code{\link{rm_main_results}()}
}
\concept{result_metrics}
