% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_functions.R
\name{generate_data}
\alias{generate_data}
\title{Generate Synthetic data}
\usage{
generate_data(
  trend = c("noTrend", "marginalTrend", "dependenceStructure"),
  n = 100
)
}
\arguments{
\item{trend}{Character vector, the trend of the generated data. Options are "noTrend",
"marginalTrend", and "dependenceStructure".}

\item{n}{Integer, the number of data points to be generated. Must be between 10
and 200, default is 100.}
}
\value{
A dataset of dimensions \eqn{n \times 2} with the generated data.
}
\description{
Synthetic data generated using copulas and marginal distributions,
with the purpose of exampling the functions of the package. Three options are given: "noTrend",
"marginalTrend", and "dependenceStructure".

The generated "noTrend" data follows a Clayton copula with fixed Kendall Tau (\eqn{\tau=0.2}).
"marginalTrend", follows the same copula, however the variables follow a Generalized Extreme Value
distribution with fixed scale and shape parameters (\eqn{\sigma=1, \xi=-0.1}),
the location is linearly non-stationary with \eqn{\mu_X = 0.05\cdot t} and \eqn{\mu_Y = 0.07\cdot t}.
Finally "dependenceStructure" presents trend in the dependence structure, the data
was generated from a Clayton copula with a linear non-stationary \eqn{\tau} parameter.
For more information we refer the reader to the source material by Goutali and Chebana (2024).
}
\examples{
# NO TREND
generate_data("noTrend", n = 50)

# TREND IN BOTH MARGINALS
generate_data("marginalTrend", n = 50)

# TREND IN DEPENDENCE STRUCTURE
generate_data("dependenceStructure", n = 50)

}
\references{
Goutali, D., and Chebana, F. (2024). Multivariate overall and dependence trend tests, applied to hydrology,
Environmental Modelling & Software, 179, \doi{10.1016/j.envsoft.2024.106090}
}
