% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{SymMatr}
\alias{SymMatr}
\title{Symmetrizer Matrix}
\usage{
SymMatr(d, n, useSparse = FALSE)
}
\arguments{
\item{d}{dimension of a vector x}

\item{n}{power of the Kronecker product}

\item{useSparse}{TRUE or FALSE. If TRUE an object of the class
"dgCMatrix" is produced.}
}
\value{
A Symmetrizer matrix with order  \eqn{{d^n} \times d^n}. If \code{useSparse=TRUE}
an object of the class "dgCMatrix" is produced.
}
\description{
Based on Chacon and Duong (2015) efficient recursive algorithms for functionals based on higher order
derivatives.  An option for sparse matrix is provided. By using sparse matrices  far
less memory is required and faster computation times are obtained
}
\examples{
a<-c(1,2)
b<-c(2,3)
c<-kronecker(kronecker(a,a),b)
## The symmetrized version of c is
as.vector(SymMatr(2,3)\%*\%c)

}
\references{
Chacon, J. E., and Duong, T. (2015). Efficient recursive algorithms
for functionals based on higher order derivatives of the multivariate Gaussian density.
Statistics and Computing, 25(5), 959-974.

Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.Section 1.3.1 Symmetrization, p.14. (1.29)
}
\seealso{
Other Matrices and commutators: 
\code{\link{EliminIndx}()},
\code{\link{EliminMatr}()},
\code{\link{MargMomCum}()},
\code{\link{QplicIndx}()},
\code{\link{QplicMatr}()},
\code{\link{SymIndx}()}
}
\concept{Matrices and commutators}
