% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecursionF.r
\name{MTCE}
\alias{MTCE}
\title{Multivariate tail conditional expectation}
\usage{
MTCE(X, cum)
}
\arguments{
\item{X}{a vector of unstandardized VaRq}

\item{cum}{list of mean, variance, skewness and kurtosis vectors}
}
\value{
Numerator of the ratio

Denominator of the ratio

MTCE Conditional expected value
}
\description{
It provides the conditional expectation
\deqn{ \text{MTCE}_q(\mathbf{X}) = \operatorname{E} \left( \mathbf{X} \mid X_1 > \text{VaR}_q (X_1),
                          X_2 > \text{VaR}_q (X_2), \dots, X_n > \text{VaR}_q (X_d) \right),}
for \eqn{q \in (0,1)}, where \eqn{\text{VaR}_q(X)} is the q-th quantile of the random variable \eqn{X}.
Expectation is taken with respect to \code{\link{GramCharlier}} with the first 4
cumulants.
}
\details{
For further details see the references below,
}
\examples{
x <- c(2,3,4)
cum <- MomCumMVt(p = 12, d = 3, r = 4, nCum = TRUE)
CE <- MTCE(x, cum)

}
\references{
Landsman, Z., Makov, U., & Shushi, T. (2016).
Multivariate tail conditional expectation for elliptical
distributions. Insurance: Mathematics and
Economics, 70, 216-223.
}
\seealso{
Other Approximations: 
\code{\link{Edgeworth}()},
\code{\link{GramCharlier}()},
\code{\link{IntEdgeworth}()},
\code{\link{IntGramCharlier}()}
}
\concept{Approximations}
