% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModEstM.R
\name{ModEstM}
\alias{ModEstM}
\title{Computes the modes, i.e. the local maxima fo the density function
for a given empirical distribution}
\usage{
ModEstM(x, ...)
}
\arguments{
\item{x}{: the random values}

\item{...}{: other parameters, passed to density. The main use of this feature
is to increase "adjust" in order to suppress spurious local density maxima.}
}
\value{
a list of the modes, in decreasing order of the corresponding density.
It allows to suppress the less significant modes, if necessary.
}
\description{
Computes the modes, i.e. the local maxima fo the density function
for a given empirical distribution
}
\examples{
require(dplyr)

x1 <- c(rbeta(1000, 23, 4))
x2 <- c(rbeta(1000, 23, 4), rbeta(1000, 4, 16))

Distribs <-
  rbind(data.frame(case = 1, XX = x1), data.frame(case = 2, XX = x2))

Adjust <- 1

Modes <- Distribs |> 
  group_by(case) |> 
  summarise(mode = ModEstM(XX, adjust = Adjust))
Modes$case
Modes$mode

ChosenCase <- 2

values <- Distribs |>
  filter(case == ChosenCase) |> 
  pull(XX)
plot(density(values, adjust = Adjust))
abline(v = Modes |> filter(case == ChosenCase) |> pull(mode) |> unlist())

}
