% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agreement0.R
\name{agreement0}
\alias{agreement0}
\title{Plot the agreement before recalibration}
\usage{
agreement0(object, rarea = FALSE)
}
\arguments{
\item{object}{list returned by \link{measure_compare} function.}

\item{rarea}{if \code{TRUE}, draw the plot with shading areas between
the confidence bands.}
}
\description{
This function draws the "agreement plot" before recalibration, which is used
to visually appraise the degree of agreement between the new and reference
methods, before recalibration of the new method.
It is obtained by graphing a scatter plot of \code{y1-y2} (difference of the methods)
versus the BLUP of the latent trait, \code{x}, along with the bias and 95\% limits
of agreement with their 95\% simultaneous confidence bands.
The function adds a second scale on the right axis, showing the percentage
of agreement index.
}
\examples{
\donttest{
### Load the data
data(data1)
### Analysis
measure_model <- measure_compare(data1, nb_simul=100)
### Plot the agreement without recalibration
agreement0(measure_model)}
}
