% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createPositionSummary.R
\name{createPositionSummary}
\alias{createPositionSummary}
\title{Summarize variants and frequencies at a genome position}
\usage{
createPositionSummary(variants, ref_aa, alt_aa, alt_aa_freq)
}
\arguments{
\item{variants}{A data frame, similar to the \code{polymorphisms} argument
of \code{\link{getEntropySignature}}, but containing
information on a single genome position.}

\item{ref_aa}{Name of the column that carries reference amino acids.}

\item{alt_aa}{Name of the column carrying alternative amino acids observed
in the metagenome.}

\item{alt_aa_freq}{Name of the column giving the frequencies of alternative
amino acids.}
}
\value{
A \code{data frame} describing the variability (different amino
acids its frequencies) observed at a specific locus.
}
\description{
This function is used internally by \code{getEntropySignature()}.
It creates a vector (\code{aminoAcids}) listing the amino acids
observed in a virome at a particular position under analysis, including the
reference amino acid, another vector (\code{frequencies}) with the
corresponding frequencies, and returns them combined in a data frame.
}
\seealso{
\code{\link{getEntropySignature}}.
}
\keyword{internal}
