% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessHotSpot.R
\name{assessHotSpot}
\alias{assessHotSpot}
\title{Evaluates Entropy Hotspot}
\usage{
assessHotSpot(profile, boundaries, chartType = "boxplot")
}
\arguments{
\item{profile}{An object of class \code{entropyProfile}.}

\item{boundaries}{Numeric vector with the first and last genomic positions
of the region to be evaluated. To be set interactively if not
provided.}

\item{chartType}{Chart type; either "boxplot", "stripchart" or "swarm".}
}
\value{
\code{htest} object. This function is called primarily for its side
effects.
}
\description{
Graphical and formal analyses of contiguous amino acids.
}
\details{
The query stretch (\emph{e.g.} a protein domain with neutralizing
epitopes) is compared against the full set of proteins. Hot spot
boundaries should be indicated relative to the reference genome
used in variant calling.
}
\examples{
omicron <- getEntropySignature(wWater[wWater$wave == "third", ])

# Entrpy hotspot at SARS-CoV-2 receptor binding domain
assessHotSpot(omicron, c(22517, 23186), chartType = "swarm")

}
\seealso{
\code{\link{getEntropySignature}}.
}
