% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mr_pcgmm-methods.R
\docType{methods}
\name{mr_pcgmm}
\alias{mr_pcgmm}
\alias{mr_pcgmm,MRInput-method}
\title{Univariable principal components generalized method of moments (PC-GMM) method}
\usage{
mr_pcgmm(
  object,
  nx,
  ny,
  r = NULL,
  thres = 0.99,
  robust = TRUE,
  alpha = 0.05,
  ...
)

\S4method{mr_pcgmm}{MRInput}(
  object,
  nx,
  ny,
  r = NULL,
  thres = 0.99,
  robust = TRUE,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{object}{An \code{MRInput} object.}

\item{nx}{The sample size used to compute genetic associations with the exposure.}

\item{ny}{The sample size used to compute genetic associations with the outcome.}

\item{r}{The number of genetic principal components to be used to instrument the exposure. Default chooses \code{r} to explain 99.9\% of variation in a sample weighted genetic correlation matrix (this can be varied by setting the \code{thres} parameter).}

\item{thres}{The threshold value of variation in the sample weighted genetic correlation matrix explained by the genetic principal components. The default value is 0.99, indicating that 99\% of variation is explained by the principal components. Note that if \code{r} and \code{thres} are both specified, then \code{r} will take precedence and \code{thres} will be ignored.}

\item{robust}{Indicates whether overdispersion heterogeneity is accounted for in the model. Default is TRUE.}

\item{alpha}{The significance level used to calculate the confidence interval. The default value is 0.05.}

\item{...}{Additional arguments to be passed to the optimization routines to calculate the GMM estimate and overdispersion parameter.}
}
\value{
The output from the function is an \code{PCGMM} object containing:

 \item{Robust}{\code{TRUE} if overdispersion heterogeneity was included in the model, \code{FALSE} otherwise.}
 \item{Exposure}{A character string with the name given to the exposure.}
 \item{Outcome}{A character string with the names given to the outcome.}
 \item{Correlation}{The matrix of genetic correlations.}
 \item{Estimate}{The causal estimate.}
 \item{StdError}{The standard error of the causal estimate.}
 \item{CILower}{The lower bound of the causal estimate based on the estimated standard error and the significance level provided.}
 \item{CIUpper}{The upper bound of the causal estimate based on the estimated standard error and the significance level provided.}
 \item{Fstat}{The first-stage F statistic for all genetic principal components used as instruments.}
 \item{Overdispersion}{The estimate of the overdispersion parameter.}
 \item{PCs}{The number of genetic principal components used to instrument the exposure.}
 \item{Pvalue}{The p-values associated with the estimates (calculated as Estimate/StdError as per Wald test) using a normal distribution.}
 \item{Alpha}{The significance level used when calculating the confidence intervals.}
 \item{Heter.Stat}{Heterogeneity statistic (Cochran's Q statistic) and associated p-value (for non-robust model only): the null hypothesis is that all genetic principal components estimate the same causal parameter; rejection of the null is an indication that one or more principal components may be pleiotropic.}
}
\description{
The \code{mr_pcgmm} function performs multivariable Mendelian randomization via the principal components generalized method of moments method.
}
\details{
When a Mendelian randomization analysis is performed using correlated genetic variants from a single gene region, there is a tradeoff between using too few variants (and compromising on power) and using too many variants (in which case, estimates can be highly sensitive to small variation in the correlation matrix). This method performs dimension reduction on a weighted version of the genetic correlation matrix to form principal components based on the genetic variants, which are then used as instruments. It is recommended not to include very highly correlated variants in this method (say, \code{r^2 > 0.95}), but the method should cope well with variants correlated below this level.

This function runs a univariable version of the PC-GMM method, which can be used when there are a single exposure associated with variants at a given gene region.

This method provides two-sample univariable Mendelian randomization estimates and associated confidence intervals that account for overdispersion heterogeneity in dimension-reduced genetic associations (when \code{robust = TRUE}).
}
\examples{
mr_pcgmm(mr_input(bx = calcium, bxse = calciumse,
   by = fastgluc, byse = fastglucse, correlation = calc.rho), nx=6351, ny=133010)

}
\references{
Description of the PC-GMM method: "Robust use of phenotypic heterogeneity at drug target genes for mechanistic insights: application of cis-multivariable Mendelian randomization to GLP1R gene region" (Preprint).
}
