#' @method screeplot MaxInt_data_analysis
#' @export
screeplot.MaxInt_data_analysis <-
function(x, ...) {
  Gamma_results <- x$Gamma_results
  # Compute (P-1)*(Q-1)
  Gamma_results$PQ_product <- (Gamma_results$P-1) * (Gamma_results$Q-1)
  Gamma_results$PQ_label <- paste0("(", Gamma_results$P, ",", Gamma_results$Q, ")")
  
  # Sort by PQ_product for correct plotting
  Gamma_results <- Gamma_results[order(Gamma_results$PQ_product), ]
  
  # Base R Plot
  plot(Gamma_results$PQ_product, Gamma_results$Gamma_value,
       type = "b", pch = 1, lwd = 2,
       xlab = expression((P-1) %.% (Q-1)),
       ylab = "interaction Explained Sum of Squares (iESS)",
       xaxt = "n", frame.plot = FALSE, ...)
  
  # Add custom x-axis
  axis(1, at = Gamma_results$PQ_product, labels = Gamma_results$PQ_product)
  
  # Add (P,Q) labels at top
  axis(3, at = Gamma_results$PQ_product, labels = Gamma_results$PQ_label, tick = TRUE, line = -1)
}
