MaxInt_data_analysis <-
function(Data, Clus, Nruns, permutations, alpha_level, verbose = TRUE) {
  
  inference_results <- data.frame(P = integer(), Q = integer(),
                                  Perm.Test.REMAXINT = numeric(), Perm.Test.EReMI = numeric(),
                                  Perm.Pval.REMAXINT = numeric(), Perm.Pval.EReMI = numeric(),
                                  Perm.Crit.REMAXINT = numeric(), Perm.Crit.EReMI = numeric())
  
  # Lists to store partitions of REMAXINT for each (P,Q)
  Gamma_REMAXINT <- list()
  Z_REMAXINT <- list()   # Row partitions
  K_REMAXINT <- list()   # Column partitions
  
  # Lists to store partitions of E-ReMI for each (P,Q)
  Gamma_EReMI <- list()
  Z_EReMI <- list()   # Row partitions
  K_EReMI <- list()   # Column partitions
  
  for (i in 1:nrow(Clus)) {
    P <- Clus[i, 1]
    Q <- Clus[i, 2]
    
    # If(verbose) to allow users to suppress messages
    if (verbose) {
      message("Running for: P = ", P, ", Q = ", Q, 
              ", permutations = ", permutations, 
              ", Nruns = ", Nruns)
    }
    
    Output <- Permutation_Function(Data, P, Q, Nruns, permutations, alpha_level)
    
    inference_results <- rbind(inference_results, data.frame(
      P = P, Q = Q,
      Perm.Test.REMAXINT = Output$Obs_Log_LR_REMAXINT,
      Perm.Test.EReMI = Output$Obs_Log_LR_EReMI,
      Perm.Pval.REMAXINT = Output$P_value_Perm_REMAXINT,
      Perm.Pval.EReMI = Output$P_value_Perm_EReMI,
      Perm.Crit.REMAXINT = Output$Crit_Value_Perm_REMAXINT,
      Perm.Crit.EReMI = Output$Crit_Value_Perm_EReMI
    ))
    
    key <- paste0("P", P, "_Q", Q)
    Gamma_REMAXINT[[key]] <- Output$Gamma_REMAXINT
    Z_REMAXINT[[key]] <- Output$Z_REMAXINT
    K_REMAXINT[[key]] <- Output$K_REMAXINT
    
    Gamma_EReMI[[key]] <- Output$Gamma_EReMI
    Z_EReMI[[key]] <- Output$Z_EReMI
    K_EReMI[[key]] <- Output$K_EReMI
  }
  
  ### Gamma values are used to make scree plot to select the optimal (P,Q). 
  ### Here i am just using Gamma_EReMI but one can also use Gamma_REMAXINT. 
  Gamma_results <- data.frame(P = integer(), Q = integer(), Gamma_value = numeric())
  
  for (key in names(Gamma_EReMI)) {
    parts <- strsplit(key, "_")[[1]]
    P <- as.integer(sub("P", "", parts[1]))
    Q <- as.integer(sub("Q", "", parts[2]))
    
    Z <- Z_EReMI[[key]]
    K <- K_EReMI[[key]]
    Gamma <- Gamma_EReMI[[key]]
    
    row_card <- colSums(Z)
    col_card <- colSums(K)
    
    total_val <- 0
    for (p_idx in 1:P) {
      for (q_idx in 1:Q) {
        total_val <- total_val +
          row_card[p_idx] * col_card[q_idx] * (Gamma[p_idx, q_idx])^2
      }
    }
    
    Gamma_val <- total_val 
    
    Gamma_results <- rbind(Gamma_results,
                           data.frame(P = P, Q = Q, Gamma_value = Gamma_val))
  }
  
  result <- list(inference_results = inference_results,
              Gamma_REMAXINT = Gamma_REMAXINT,
              Z_REMAXINT = Z_REMAXINT,
              K_REMAXINT = K_REMAXINT,
              Gamma_REMAXINT = Gamma_REMAXINT,
              Z_EReMI = Z_EReMI,
              K_EReMI = K_EReMI,
              Gamma_EReMI = Gamma_EReMI,
              Gamma_results=Gamma_results)
  class(result) <- "MaxInt_data_analysis"
  return(result)
}
