% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrainingParams.R
\name{set_optim}
\alias{set_optim}
\alias{set_optim_bayes}
\alias{set_optim_bayes.ModelSpecification}
\alias{set_optim_bfgs}
\alias{set_optim_bfgs.ModelSpecification}
\alias{set_optim_grid}
\alias{set_optim_grid.TrainingParams}
\alias{set_optim_grid.ModelSpecification}
\alias{set_optim_grid.TunedInput}
\alias{set_optim_grid.TunedModel}
\alias{set_optim_pso}
\alias{set_optim_pso.ModelSpecification}
\alias{set_optim_sann}
\alias{set_optim_sann.ModelSpecification}
\alias{set_optim_method}
\alias{set_optim_method.ModelSpecification}
\title{Tuning Parameter Optimization}
\usage{
set_optim_bayes(object, ...)

\method{set_optim_bayes}{ModelSpecification}(
  object,
  num_init = 5,
  times = 10,
  each = 1,
  acquisition = c("ucb", "ei", "eips", "poi"),
  kappa = stats::qnorm(conf),
  conf = 0.995,
  epsilon = 0,
  control = list(),
  packages = c("ParBayesianOptimization", "rBayesianOptimization"),
  random = FALSE,
  progress = verbose,
  verbose = 0,
  ...
)

set_optim_bfgs(object, ...)

\method{set_optim_bfgs}{ModelSpecification}(
  object,
  times = 10,
  control = list(),
  random = FALSE,
  progress = FALSE,
  verbose = 0,
  ...
)

set_optim_grid(object, ...)

\method{set_optim_grid}{TrainingParams}(object, random = FALSE, progress = FALSE, ...)

\method{set_optim_grid}{ModelSpecification}(object, ...)

\method{set_optim_grid}{TunedInput}(object, ...)

\method{set_optim_grid}{TunedModel}(object, ...)

set_optim_pso(object, ...)

\method{set_optim_pso}{ModelSpecification}(
  object,
  times = 10,
  each = NULL,
  control = list(),
  random = FALSE,
  progress = FALSE,
  verbose = 0,
  ...
)

set_optim_sann(object, ...)

\method{set_optim_sann}{ModelSpecification}(
  object,
  times = 10,
  control = list(),
  random = FALSE,
  progress = FALSE,
  verbose = 0,
  ...
)

set_optim_method(object, ...)

\method{set_optim_method}{ModelSpecification}(
  object,
  fun,
  label = "Optimization Function",
  packages = character(),
  params = list(),
  random = FALSE,
  progress = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{\link[=inputs]{input} or \link[=models]{model} object.}

\item{...}{arguments passed to the \code{TrainingParams} method of
\code{set_optim_grid} from its other methods.}

\item{num_init}{number of grid points to sample for the initialization of
Bayesian optimization.}

\item{times}{maximum number of times to repeat the optimization step.
Multiple sets of model parameters are evaluated automatically at each step
of the BFGS algorithm to compute a finite-difference approximation to the
gradient.}

\item{each}{number of times to sample and evaluate model parameters at each
optimization step.  This is the swarm size in particle swarm optimization,
which defaults to \code{floor(10 + 2 * sqrt(length(bounds)))}.}

\item{acquisition}{character string specifying the acquisition function as
\code{"ucb"} (upper confidence bound), \code{"ei"} (expected improvement),
\code{"eips"} (expected improvement per second), or \code{"poi"}
(probability of improvement).}

\item{kappa, conf}{upper confidence bound (\code{"ucb"}) quantile or its
probability to balance exploitation against exploration.  Argument
\code{kappa} takes precedence if both are given and multiplies the
predictive standard deviation added to the predictive mean in the
acquisition function.  Larger values encourage exploration of the model
parameter space.}

\item{epsilon}{improvement methods (\code{"ei"}, \code{"eips"}, and
\code{"poi"}) parameter to balance exploitation against exploration.
Values should be between -0.1 and 0.1 with larger ones encouraging
exploration.}

\item{control}{list of control parameters passed to
\code{bayesOpt} by \code{set_optim_bayes} with package
\code{"ParBayesianOptimization"}, to
\code{\link[rBayesianOptimization]{BayesianOptimization}} by
\code{set_optim_bayes} with package \code{"rBayesianOptimization"}, to
\code{\link[stats]{optim}} by \code{set_optim_bfgs} and
\code{set_optim_sann}, and to \code{\link[pso]{psoptim}} by
\code{set_optim_pso}.}

\item{packages}{R package or packages to use for the optimization method, or
an empty vector if none are needed.  The first package in
\code{set_optim_bayes} is used unless otherwise specified by the user.}

\item{random}{number of points to sample for a random grid search, or
\code{FALSE} for an exhaustive grid search.  Used when a grid search is
specified or as the fallback method for non-numeric model parameters
present during other optimization methods.}

\item{progress}{logical indicating whether to display iterative progress
during optimization.}

\item{verbose}{numeric or logical value specifying the level of progress
detail to print, with 0 (\code{FALSE}) indicating none and 1 (\code{TRUE})
or higher indicating increasing amounts of detail.}

\item{fun}{user-defined optimization function to which the arguments below
are passed in order.  An ellipsis can be included in the function
definition when using only a subset of the arguments and ignoring others.
A tibble returned by the function with the same number of rows as model
evaluations will be included in a \code{TrainingStep} summary of
optimization results; other types of return values will be ignored.
\describe{
  \item{optim}{function that takes a numeric vector or list of named
    model parameters as the first argument, optionally accepts the maximum
    number of iterations as argument \code{max_iter}, and returns a scalar
    measure of performance to be maximized.  Parameter names are available
    from the \code{grid} and \code{bounds} arguments described below.  If
    the function cannot be evaluated at a given set of parameter values,
    then \code{-Inf} is returned.}
  \item{grid}{data frame containing a tuning grid of all model parameters.}
  \item{bounds}{named list of lower and upper bounds for each finite
    numeric model parameter in \code{grid}.  The types (integer or double)
    of the original parameter values are preserved in the bounds.}
  \item{params}{list of optimization parameters as supplied to
    \code{set_optim_method}.}
  \item{monitor}{list of the \code{progress} and \code{verbose} values.}
}}

\item{label}{character descriptor for the optimization method.}

\item{params}{list of user-specified model parameters to be passed to
\code{fun}.}
}
\value{
Argument \code{object} updated with the specified optimization method
and control parameters.
}
\description{
Set the optimization method and control parameters for tuning of model
parameters.
}
\details{
The optimization functions implement the following methods.
\describe{
  \item{\code{set_optim_bayes}}{Bayesian optimization with a Gaussian process
    model (Snoek et al. 2012).}
  \item{\code{set_optim_bfgs}}{limited-memory modification of quasi-Newton
    BFGS optimization (Byrd et al. 1995).}
  \item{\code{set_optim_grid}}{exhaustive or random grid search.}
  \item{\code{set_optim_pso}}{particle swarm optimization (Bratton and
    Kennedy 2007, Zambrano-Bigiarini et al. 2013).}
  \item{\code{set_optim_sann}}{simulated annealing (Belisle 1992).  This
    method depends critically on the control parameter settings.  It is
    not a general-purpose method but can be very useful in getting to good
    parameter values on a very rough optimization surface.}
  \item{\code{set_optim_method}}{user-defined optimization function.}
}
The package-defined optimization functions evaluate and return values of the
tuning parameters that are of same type (e.g. integer, double, character) as
given in the \code{object} grid.  Sequential optimization of numeric tuning
parameters is performed over a hypercube defined by their minimum and maximum
grid values.  Non-numeric parameters are optimized with grid searches.
}
\examples{
ModelSpecification(
  sale_amount ~ ., data = ICHomes,
  model = TunedModel(GBMModel)
) \%>\% set_optim_bayes(package = "rBayesianOptimization")

}
\references{
Belisle, C. J. P. (1992). Convergence theorems for a class of simulated
annealing algorithms on Rd. \emph{Journal of Applied Probability},
\emph{29}, 885–895.

Bratton, D. & Kennedy, J. (2007), Defining a standard for particle swarm
optimization. In \emph{IEEE Swarm Intelligence Symposium, 2007} (pp.
120-127).

Byrd, R. H., Lu, P., Nocedal, J., & Zhu, C. (1995). A limited memory
algorithm for bound constrained optimization. \emph{SIAM Journal on
Scientific Computing}, \emph{16}, 1190–1208.

Snoek, J., Larochelle, H., & Adams, R.P. (2012). Practical Bayesian
Optimization of Machine Learning Algorithms. arXiv:1206.2944 [stat.ML].

Zambrano-Bigiarini, M., Clerc, M., & Rojas, R. (2013). Standard particle
swarm optimisation 2011 at CEC-2013: A baseline for future PSO improvements.
In \emph{IEEE Congress on Evolutionary Computation, 2013} (pp. 2337-2344).
}
\seealso{
\code{\link[rBayesianOptimization]{BayesianOptimization}},
\code{bayesOpt}, \code{\link[stats]{optim}}, \code{\link[pso]{psoptim}},
\code{\link{set_monitor}}, \code{\link{set_predict}},
\code{\link{set_strata}}
}
