% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_integrated_gradients}
\alias{plot_integrated_gradients}
\title{Plotting Integrated Gradients Plots}
\usage{
plot_integrated_gradients(analysis_object, show_table = FALSE)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with
'sensitivity_analysis(methods = "Integrated Gradients")'.}

\item{show_table}{Boolean. Whether to print Integrated Gradients summarized
results table.}
}
\value{
analysis_object
}
\description{
The \strong{plot_integrated_gradients()} function implements interpretability
visualizations of integrated gradient attributions measuring feature
importance through accumulated gradients along the interpolation path from
baseline (zero vector) to observed input. Provides four visualization
modalities: mean absolute attributions (bar plots), directional effects
showing positive and negative contribution patterns (directional plots),
distributional properties of attributions across instances (box plots),
and individual-level attribution contributions (swarm plots).
}
\examples{
# Note: For obtaining the Integrated Gradients plot the user needs to
# complete till sensitivity_analysis( ) function of the MLwrap pipeline
# using the Integrated Gradients method.
# See the full pipeline example under sensitivity_analysis()
# (Requires sensitivity_analysis(methods = "Integrated Gradients"))
# Final call signature:
# plot_integrated_gradients(wrap_object)
}
\seealso{
\code{\link{sensitivity_analysis}}
}
