% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kFWER_adjP.R
\name{gsidak.cv}
\alias{gsidak.cv}
\title{Critical Value for the generalized Sidak Procedure Controlling k-FWER}
\usage{
gsidak.cv(m, k, alpha)
}
\arguments{
\item{m}{number of hypotheses to be tested.}

\item{k}{number of allowed type 1 errors in k-FWER controls.}

\item{alpha}{significant level used to compare with adjusted p-values to make decisions, the default value is 0.05.}
}
\value{
A numeric vector of the adjusted p-values (of the same length as \code{p}) if  \code{make.decision = FALSE}, or a list including original p-values, adjusted p-values and decision rules if \code{make.decision = TRUE}.
}
\description{
The function for computing the critical value based on number of hypotheses \eqn{m}, fold \eqn{k} and significant level \eqn{\alpha}.
}
\examples{
p <- c(0.031,0.023,0.029,0.005,0.031,0.000,0.874,0.399,0.293,0.077)
gsidak.cv(m=length(p), k=2)
}
\seealso{
\code{\link{gsidak.p.adjust}}, \code{\link[stats]{p.adjust}}, \code{\link[MHTdiscrete]{Sidak.p.adjust}}.
}
\author{
Yalin Zhu
}
