% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DFDR_adjP.R
\name{DFDR2.p.adjust}
\alias{DFDR2.p.adjust}
\title{Adjusted P-Values for the Modified Double FDR Procedure}
\usage{
DFDR2.p.adjust(pval, t, make.decision)
}
\arguments{
\item{pval}{the structural p-values, the type should be \code{"list"}.}

\item{t}{the threshold selecting significant families and testing hypotheses.}

\item{make.decision}{logical; if \code{TRUE}, then the output include the decision rules compared adjusted p-values with significant level \eqn{\alpha}.}
}
\value{
A list of the adjusted p-values, a list of \code{NULL} means the family is not selected to do the test in the second stage.
}
\description{
Given a list/data frame of grouped p-values, retruns adjusted p-values to make decisions
}
\examples{
# data is from Example 4.1 in Mehrotra and Adewale (2012)
pval <- list(c(0.031,0.023,0.029,0.005,0.031,0.000,0.874,0.399,0.293,0.077),
             c(0.216,0.843,0.864),
             c(1,0.878,0.766,0.598,0.011,0.864),
             c(0.889,0.557,0.767,0.009,0.644),
             c(1,0.583,0.147,0.789,0.217,1,0.02,0.784,0.579,0.439),
             c(0.898,0.619,0.193,0.806,0.611,0.526,0.702,0.196))
DFDR2.p.adjust(pval = pval,t=0.1)
sum(unlist(DFDR2.p.adjust(pval = pval,t=0.1))<=0.1)
}
\references{
Mehrotra, D. V., & Adewale, A. J. (2012).
Flagging clinical adverse experiences: reducing false discoveries without materially compromising power for detecting true signals.
\emph{Statistics in medicine}, \strong{31}: 1918-1930.
}
\seealso{
\code{\link{DFDR.p.adjust}}, \code{\link[stats]{p.adjust}}.
}
\author{
Yalin Zhu
}
