% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexis.grid2.R
\name{lexis.grid2}
\alias{lexis.grid2}
\title{Deprecated. Plot a Lexis grid}
\usage{
lexis.grid2(year.start, year.end, age.start, age.end, lwd = 0.3,
  force.equal = T, d = 1)
}
\arguments{
\item{year.start}{integer, set the year the Lexis Diagram starts with.}

\item{year.end}{integer, set the year the Lexis Diagram ends with.}

\item{age.start}{integer, set the age the Lexis Diagram starts with.}

\item{age.end}{integer, set the age the Lexis Diagram ends with.}

\item{lwd}{numeric, set the linewidth of the grid.}

\item{force.equal}{logical, by default \code{lexis.grid} uses \code{ggplot2::coord_fixed()} to ensure isosceles trianlges. Set \code{FALSE} to allow for a non-isosceles appearance.}

\item{d}{numeric, set the size of the age groups. Default is 1.}
}
\value{
The functions returns a ggplot2-plot.
}
\description{
lexis.grid() plots the basic Lexis grid.
}
\details{
The function determines the aspect ratio of the x- and y-axis to enforce
isosceles triangles. The aspect ratio will not be effected by defining
\code{width} and \code{height} in \code{pdf()} or other graphic devices.

Because the returned object is a ggplot2 graph, the overall appearence of
the graph can be edited by adding \code{themes()} to the plot.
}
\examples{
\dontrun{
library(LexisPlotR)
lexis.grid(year.start = 1900, year.end = 1905, age.start = 0, age.end = 5)
}
}
\author{
Philipp Ottolinger
}
