% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance.CI.R
\name{variance.CI}
\alias{variance.CI}
\title{Confidence Interval for the Variance and the Standard Deviation of a Normal Population}
\usage{
variance.CI(x = NULL, s = NULL, sc = NULL, smu = NULL, mu = NULL,
  n = NULL, conf.level)
}
\arguments{
\item{x}{a numeric vector containing the sample.}

\item{s}{a single numeric value corresponding with the sample standard deviation.}

\item{sc}{a single numeric value corresponding with the cuasi-standard deviation.}

\item{smu}{if known, a single numeric value corresponding with the estimation of the standard deviation for known population mean.}

\item{mu}{if known, a single numeric value corresponding with the population mean. Even when the user provides smu, mu is still needed.}

\item{n}{a single positive integer corresponding with the sample size; not needed if the sample is provided.}

\item{conf.level}{a single numeric value corresponding with the confidence level of the interval; must be a value in (0,1).}
}
\value{
A list containing the following components:
\item{var.estimate}{the cuasi-variance for unknown population mean, and the estimation of the variance for known population mean.}
\item{sd.estimate}{the cuasi-standard deviation for unknown population mean and the estimation of the standard deviation for known population mean.}
\item{CI.var}{a numeric vector of length two containing the lower and upper bounds of the confidence interval for the population variance.}
\item{CI.sd}{a numeric vector of length two containing the lower and upper bounds of the confidence interval for the population standard deviation.}
Independently on the user saving those values, the function provides a summary of the result on the console.
}
\description{
\code{variance.CI} provides a pointwise estimation and a confidence interval for the variance and the standard deviation of a normal population in both scenarios: known and unknown population mean.
}
\details{
The formula interface is applicable when the user provides the sample and also when the user provides the value of sample characteristics (cuasi-standard deviation or sample standard deviation and the sample size).
}
\examples{
#Given the estimation of the standard deviation with known population mean
dat=rnorm(20,mean=2,sd=1)
smu=Smu(dat,mu=2)
variance.CI(smu=smu,mu=2,n=20,conf.level=0.95)

#Given the sample with known population mean
dat=rnorm(20,mean=2,sd=1)
variance.CI(dat,mu=2,conf.level=0.95)

#Given the sample with unknown population mean
dat=rnorm(20,mean=2,sd=1)
variance.CI(dat,conf.level=0.95)

#Given the cuasi-standard deviation with unknown population mean
dat=rnorm(20,mean=2,sd=1)
variance.CI(sc=sd(dat),n=20,conf.level=0.95)

}
