% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSnedecor.R
\name{plotFS}
\alias{plotFS}
\title{Density Function, Distribution Function and/or
Quantile Function Representations associated with a F-Snedecor Distribution}
\usage{
plotFS(df1, df2, type = "b", col = "black")
}
\arguments{
\item{df1, df2}{the degrees of freedom of the F-Snedecor distribution.}

\item{type}{a character string giving the type of desired plot. The following values are possible:
"b" (default) for density function, distribution function and quantile function representations together,
"dis" for distribution function representation,
"den" for density function representation and "q" for quantile function representation.}

\item{col}{a single colour associated with the different representations; default to "black".}
}
\value{
This function is called for the side effect of drawing the plot.
}
\description{
\code{plotBeta} represents density, distribution and/or quantile functions associated with a F-Snedecor
 distribution with certain \code{df1} and \code{df2} degrees of freedom.
}
\examples{
df1=10;df2=15
plotFS(df1,df2)
plotFS(df1,df2,col="red")
plotFS(df1,df2,type="q")
plotFS(df1,df2,type="dis")
plotFS(df1,df2,type="den")
}
