% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_designDiagram.R
\name{designDiagram-class}
\alias{designDiagram-class}
\alias{print.designDiagram}
\alias{summary.designDiagram}
\alias{update.designDiagram}
\alias{plot.designDiagram}
\title{The \code{designDiagram} class and some basic methods}
\usage{
\method{print}{designDiagram}(x, ...)

\method{summary}{designDiagram}(object, ...)

\method{update}{designDiagram}(object, ...)

\method{plot}{designDiagram}(
  x,
  circle = "none",
  pvalue = (circle == "MSS"),
  sigma2 = NULL,
  kill = ~1,
  ca = FALSE,
  max.area = NULL,
  relative = 0.01,
  color = NULL,
  circle.scaling = 1,
  arrow.type = arrow(angle = 20, length = unit(4, "mm")),
  xlim = c(0, 1),
  ylim = c(0, 1),
  horizontal = TRUE,
  ...
)
}
\arguments{
\item{x}{object of class \code{designDiagram}}

\item{...}{not used.}

\item{object}{object of class \code{designDiagram}}

\item{circle}{character specifying which circles to draw at the terms: \code{"none"}=no circles, \code{"SS"}=a circle with area proportional to the associated Sum-of-Squares, \code{"MSS"}=a circle with area proportional to the associated Mean-Sum-of-Squares, \code{"I"}=a circle with area proportional to average information, \code{"I2"}=a circle with area proportional to average information of the parameter contrasts. Defaults to \code{"none"}.}

\item{pvalue}{boolean specifying whether p-values should be inserted on the graphs. This is only possible if a response variable was specified. Defaults to \code{TRUE} is \code{circle="MSS"} and \code{FALSE} otherwise.}

\item{sigma2}{vector of random effects variances. Defaults to \code{NULL}, in which case the estimates are used (if present), otherwise all variances are set to 1.}

\item{kill}{formula specifying which cirlces not to plot. Defaults to \code{~1} corresponding to not plotting the intercept term (that otherwise may overweight the remaining terms).}

\item{ca}{boolean deciding whether collinearity analysis is visualized. If \code{NULL} then set \code{TRUE} for non-orthogonal designs, and to \code{FALSE} for orthogonal designs. Defaults to \code{FALSE}.}

\item{max.area}{numeric specifying the used maximal area of circles. If \code{NULL} then \code{max.area} is derived from \code{SS}, \code{MSS} or \code{I} according to value of \code{circle}. Defaults to \code{NULL}.}

\item{relative}{positive numeric, which specifies needed relative increase for an area to be visualized in the collinearity analysis. Defaults to \code{0.01}.}

\item{color}{color of circles when \code{ca=FALSE}. Defaults to \code{NULL} corresponding to preassigned choice of colors (see details below).}

\item{circle.scaling}{numeric specifying size scaling of circles. Defaults to \code{1}, which corresponds to the largest circle having a radius that is half of the shortest distance between two nodes.}

\item{arrow.type}{specifying arrow heads via \code{\link[grid]{arrow}}. Defaults to \code{arrow(angle=20,length=unit(4,"mm"))}.}

\item{xlim}{x-range of diagram plot. Defaults to \code{c(0,1)}.}

\item{ylim}{y-range of diagram plot. Defaults to \code{c(0,1)}.}

\item{horizontal}{boolean specifying if the design diagram should be drawn horizontally or vertically. Defaults to \code{TRUE}.}
}
\description{
Objects of class \code{designDiagram} as generated by \code{\link{DD}} is a list with entries as specified below.
\describe{
\item{\code{response}}{Logical stating whether a response variable was present.}
\item{\code{terms}}{Named vector with all terms in the design.}
\item{\code{random.terms}}{Vector with the random terms in the design.}
\item{\code{relations}}{Named matrix with relations between variables with the following interpretation: "0"=linear indepent, "<"=row term is a subspace of column, "<-"=row term is a subspace of column term and no other terms are inbetween, ">" and "->" the similar interpretatioin between columns and rows, name=name of minimum between row and column term.}
\item{\code{inner}}{Named matrix of squared inner products of subspaces with nesting subspaces removed. Rounded at order of \code{eps} in the call to \code{link{DD}}. Used to decide orthogonality of the design.}
\item{\code{Nparm}}{Named vector with the number of parameters for the terms.}
\item{\code{df}}{Named vector with the degrees of freedom for the terms.}
\item{\code{SS}}{Named matrix with Sum-of-Squares if a response variable was specified.}
\item{\code{MSS}}{Named matrix with Mean-Sum-of-Squares if a response variable was specified.}
\item{\code{pvalue}}{Named matrix with p-values for Type-I F-tests. p-values are stated at the collapsed nesting, but F-test are done against the most coarse nested random effect.}
\item{\code{sigma2}}{Named vector of random effects variance estimates.}
\item{\code{varcov}}{Named list of variance-covariance matrix for fixed effects relative to each of the random effects. Rounded at order of \code{eps}.}
\item{\code{coordinates}}{Data frame with node coordinates of the terms. Initialized in Sugiyama layout.}
}
}
\details{
For \code{plot.designDiagram} the options \code{circle="SS"} and \code{circle="MSS"} are only available if a response variable was specified for the design.
For \code{circle="I"} and \code{circle="I2"} the color of the circles visualize the coefficient of variation of the informations. For the computation of the informations the variances of the random effects are either estimated (if a response variable is present), all set to 1 (otherwise), or given via the option \code{sigma2}.

If \code{color=NULL} and \code{ca=FALSE}, then the defaults colors are \code{"lightgreen"} for Sum-of-Squares, \code{"lightblue"} for Mean-Sum-of-Squares, and a gradient from \code{"limegreen"} to \code{"orange"} for information spread. To specify a different color gradient in the latter case, then give a vector of two colors.

For \code{update.designDiagram} the second argument should be a data frame with new \code{coordinates}. This can be usefull for manually setting the coordinates for plotting.
}
\seealso{
\code{\link{DD}}
}
