% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation.R
\name{imputeQuantities}
\alias{imputeQuantities}
\title{Impute quantities when only prices are available}
\usage{
imputeQuantities(x, pvar, pervar, prodID)
}
\arguments{
\item{x}{A dataframe containing price, quantity, a time period identifier
and a product identifier. It must have column names.}

\item{pvar}{A character string for the name of the price variable}

\item{pervar}{A character string for the name of the time variable. This variable
must contain integers starting at period 1 and increasing in increments of 1 period.
There may be observations on multiple products for each time period.}

\item{prodID}{A character string for the name of the product identifier}
}
\description{
This procedure calculates quantities in such a way that
the expenditure shares on all products are equal in each
period. It is used to compute quantities for the predicted
share measure of relative price dissimilarity when there are
none available.
}
