% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transdistfuncs.r
\name{get.transdist.theta}
\alias{get.transdist.theta}
\title{Get weights of transmission distance theta}
\usage{
get.transdist.theta(
  wal.teun.mat,
  cases,
  gen.t.mean,
  max.sep,
  ret.theta.mat = FALSE
)
}
\arguments{
\item{wal.teun.mat}{a Wallinga-Teunis matrix produced by the \code{est.wt.matrix} function}

\item{cases}{a vector of case times for each case}

\item{gen.t.mean}{the mean generation time of the infecting pathogen}

\item{max.sep}{maximum number of transmission events allowed between two cases}

\item{ret.theta.mat}{logical value which returns the matrix of estimated theta values (default = FALSE)}
}
\value{
a three-dimensional array containing normalized theta weights. Columns and rows represent unique case times. The third dimension is the number of transmission events between two cases.
}
\description{
This function estimates the weights of each theta (number of transmission events separating cases at two time points). A randomized transmission tree is drawn and the number of transmission events
separating cases at two time points is calculated based on probabilies found in the Wallinga-Teunis matrix.
}
\examples{
\donttest{

case.times <- c(1,2,2,3,3)
gen <- c(0, 2/3, 1/3, 0, 0)
t.density <- gen/sum(gen)

gen.time <- 2 # mean generation time

wt <- est.wt.matrix(case.times=case.times, gen.t.dist=t.density)

ngen <- round((max(case.times) - min(case.times)) / gen.time) + 1 # Number of generations

a <- get.transdist.theta(wal.teun.mat=wt,
                         cases=case.times,
                         gen.t.mean=gen.time,
                         max.sep=ngen*2)

}
}
\references{
Salje H, Cummings DAT and Lessler J (2016). “Estimating infectious disease transmission distances using the overall distribution of cases.” Epidemics, 17, pp. 10–18. ISSN 1755-4365, doi: \href{https://www.sciencedirect.com/science/article/pii/S1755436516300317}{10.1016/j.epidem.2016.10.001}.
}
\seealso{
Other transdist: 
\code{\link{est.transdist}()},
\code{\link{est.transdist.bootstrap.ci}()},
\code{\link{est.transdist.temporal}()},
\code{\link{est.transdist.temporal.bootstrap.ci}()},
\code{\link{est.transdist.theta.weights}()}
}
\author{
John Giles, Justin Lessler, and Henrik Salje
}
\concept{transdist}
