# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Efficiently compute Moran's I statistic
#'
#' Compute Moran's I for a matrix. A fast implementation of Moran's I for
#' gridded data, with neighbours defined based on a radial distance. Note
#' that when using radius to define the neighbourhood, a radius of one
#' corresponds to the rook's neibhourhood. There is currently no
#' equivalent to queen's neighbourhood.
#'
#' @param mat1 a matrix of values; NA/Inf values must be coded as NA and are ignored
#' @param r1 an integer representing the distance (radius), within which nearby
#'     cells are considered neighbours in units of rows/columns
#'
#' @return a single numeric value for Moran's I
#'
#' @export
#'
#' @examples
#' (TestMat <- matrix(c(1, 0, 1, 0, 1,
#'                      0, 1, 0, 1, 0,
#'                      1, 0, 1, 0, 1,
#'                      0, 1, 0, 1, 0,
#'                      1, 0, 1, 0, 1),
#'                    nrow =5))
#' # the code below should return -1
#' MoransI(TestMat, r1 = 1)
MoransI <- function(mat1, r1) {
    .Call('_ICvectorfields_MoransI', PACKAGE = 'ICvectorfields', mat1, r1)
}

