% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDSpatialScan_plot.R
\name{plot.ResScanOutput}
\alias{plot.ResScanOutput}
\title{Schema or map of the clusters}
\usage{
\method{plot}{ResScanOutput}(
  x,
  type,
  spobject = NULL,
  system_conv = NULL,
  colors = "red",
  only.MLC = FALSE,
  ...
)
}
\arguments{
\item{x}{ResScanOutput. Output of a scan function (UG, UNP, MG, MNP, PFSS, DFFSS, URBFSS, NPFSS, MPFSS, MDFFSS or MRBFSS)}

\item{type}{character. Type of plot: "schema", "map" (the clusters are represented by circles) or "map2" (the clusters are colored on the map)}

\item{spobject}{SpObject. SpatialObject with the same coordinates system the one used for the scan. Only considered if type is "map" or "map2"}

\item{system_conv}{character. System to convert the coordinates for the plot. Only considered if the system used in the scan was "WGS84" and if type is "schema". Else it will be ignored. Must be entered as in the PROJ.4 documentation}

\item{colors}{character. Colors of the clusters. If length(colors)=1 all the clusters will be in this color. Else it should be a vector of length the number of clusters to plot.}

\item{only.MLC}{logical. Should we plot only the MLC or all the significant clusters?}

\item{...}{Further arguments to be passed to or from methods.}
}
\value{
No value returned, plots a schema or a map of the sites and the clusters.
}
\description{
This function plots a schema or a map of the sites and the clusters
}
\examples{
\donttest{
library(sp)
data("map_sites")
data("funi_data")
coords <- coordinates(map_sites)

res_npfss <- SpatialScan(method = "NPFSS", data = funi_data, sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2)$NPFSS

plot(x = res_npfss, type = "schema", system_conv = "+init=epsg:2154")
plot(x = res_npfss, type = "map", spobject = map_sites)
plot(x = res_npfss, type = "map2", spobject = map_sites)}
\dontshow{
library(sp)
data("map_sites")
data("funi_data")
indices <- c(51:75)
coords <- coordinates(map_sites[indices,])
res_npfss <- SpatialScan(method = "NPFSS", data = funi_data[indices,],
sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2, MC = 99)$NPFSS
if(length(res_npfss$sites_clusters)>0){
plot(x = res_npfss, type = "schema", system_conv = "+init=epsg:2154")
plot(x = res_npfss, type = "map", spobject = map_sites[indices,])
plot(x = res_npfss, type = "map2", spobject = map_sites[indices,])
}

}

}
