% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared.R
\name{safe_cov_inverse}
\alias{safe_cov_inverse}
\title{Computes a numerically stable inverse of a covariance matrix}
\usage{
safe_cov_inverse(X, ridge = 1e-08, max_ridge_steps = 6)
}
\arguments{
\item{X}{The n x p design matrix}

\item{ridge}{Initial ridge penalty added to the diagonal}

\item{max_ridge_steps}{Maximum number of ridge escalation attempts}
}
\value{
The inverse covariance matrix
}
\description{
Computes a numerically stable inverse of a covariance matrix
}
\examples{
\dontrun{
X = matrix(rnorm(20), nrow = 10)
Sinv = safe_cov_inverse(X)
dim(Sinv)
}
}
\author{
Adam Kapelner
}
